package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.AppBulletinDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 16/9/10.
 */
@AdvancedFeignClient
public interface RemoteAppBulletinService {
    /**
     * 获取首页公告配置
     * @param appId
     * @return
     */
    DubboResult<AppBulletinDto> findAppBulletinDtoByAppId(Long appId);

    /**
     * 获取公告详情
     * @param appId
     * @return
     */
    DubboResult<String> findAppBulletinDetailByAppId(Long appId);

    /**
     * 获取首页公告配置(开发者后台用)
     * @param appId
     * @return
     */
    DubboResult<AppBulletinDto> findByAppId(Long appId);

    /**
     * 添加首页公告配置
     * @param appBulletinDto
     * @return
     */
    DubboResult<Integer> insert(AppBulletinDto appBulletinDto);

    /**
     * 更新首页公告配置
     * @param appBulletinDto
     * @return
     */
    DubboResult<Integer> update(AppBulletinDto appBulletinDto);

}
