package cn.com.duiba.developer.center.api.domain.param.authority;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

public class WhiteListParam implements Serializable {


    private static final long serialVersionUID = -8032929198331260579L;
    /**
     * 业务名称
     */
    @NotNull(message = "业务名称不能为空")
    private String bizName;

    /**
     * 1 白名单 2 黑名单 3 json
     */
    @NotNull(message =  "业务类型不能为空")
    private Integer bizType;


    /**
     * 白名单描述
     */
    private String description;


    /**
     * 主键
     */
    private Long id;

    /**
     * 业务唯一编码
     */
    @NotNull(message = "业务编码不能为空")
    private String uniqueCode;


    /**
     * json 内容
     */
    private String bizContent;

    /**
     * 名单内容
     */
    private List<String> relValues;

    /**
     * 0  关  1  开
     */
    private Integer openStatus;

    /**
     * 创建人id
     */
    private Long createAdmin;

    /**
     * 修改人id
     */
    private Long modifyAdmin;


    public Long getCreateAdmin() {
        return createAdmin;
    }

    public void setCreateAdmin(Long createAdmin) {
        this.createAdmin = createAdmin;
    }

    public Long getModifyAdmin() {
        return modifyAdmin;
    }

    public void setModifyAdmin(Long modifyAdmin) {
        this.modifyAdmin = modifyAdmin;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public String getBizContent() {
        return bizContent;
    }

    public void setBizContent(String bizContent) {
        this.bizContent = bizContent;
    }

    public List<String> getRelValues() {
        return relValues;
    }

    public void setRelValues(List<String> relValues) {
        this.relValues = relValues;
    }

    public void setBizName(String bizName) {
        this.bizName = bizName;
    }

    public String getBizName() {
        return bizName;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public Integer getBizType() {
        return bizType;
    }


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }


    public void setUniqueCode(String uniqueCode) {
        this.uniqueCode = uniqueCode;
    }

    public String getUniqueCode() {
        return uniqueCode;
    }


    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
