package cn.com.duiba.developer.center.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.crm.ClueAppIndentInfoDto;

import java.util.List;

/**
 * @author 刘凯
 * @date 2020-06-12
 */
@AdvancedFeignClient
public interface RemoteClueAppIndentInfoService {


    Long save(ClueAppIndentInfoDto clueAppIndentInfoDto);

    void saveBatch(List<ClueAppIndentInfoDto> clueAppIndentInfoDtos);

    Long deleteById(Long id);

    Long deleteBatchByIds(List<Long> ids);

    Long updateById(ClueAppIndentInfoDto clueAppIndentInfoDto);

    ClueAppIndentInfoDto getById(Long id);

    List<ClueAppIndentInfoDto> listByIds(List<Long> ids);

    /**
     * 查询应用数据
     * @param type 应用的版本类型
     * @param clueAppId
     * @param wasValide true 表示获取有效的版本 对应的数据
     * @return
     */
    List<ClueAppIndentInfoDto> getByTypeAndClueAppId(Integer type,Long clueAppId,Boolean wasValide);

    /**
     * 应用线索ids 查询
     * @param clueAppIds
     * @return
     */
    List<ClueAppIndentInfoDto> getByclueAppIds(List<Long> clueAppIds);

    /**
     * 用户定时任务 获取应用线索id
     * 若应用的版本不为「试用版本」
     * 并且在到期前 3 个月时应用阶段为「待激活」或「上线中」则自动将应用阶段修改为「续费期」
     * （比如 2020 年 6 月 1 日到期，则 2020 年 3 月 1 日进入续费期）。
     * @return
     */
    List<Long>  getChangeClueAppIds();

}
