package cn.com.duiba.developer.center.api.remoteservice.forum;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.forum.AdminInfoDto;

import java.util.List;

/**
 * @Auther: linjianhui
 * @Date: 2018/11/15 11:53
 * @Description:  管理后台用户信息服务
 */
@AdvancedFeignClient
public interface RemoteForumAdminService {

    /**
     * 通过adminId获取后台用户信息
     * @param adminId
     * @param adminEmail
     * @return
     */
    AdminInfoDto selectByAdminId(Long adminId,String adminEmail);

    /**
     * 编辑管理后台用户信息
     * @param adminInfoDto
     * @return
     */
    Boolean updateAdminInfo(AdminInfoDto adminInfoDto);

    /**
     * 通过adminIds批量获取后台用户信息
     * @param adminIds
     * @return
     */
    List<AdminInfoDto> selectByAdminIds(List<Long> adminIds);
}
