package cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.convert;


import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.bean.*;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class FancyRespConvert {

    public AdxCommonBidResponse convert(BidResponse bidResponse) {
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(bidResponse.getId());
        commonBidResponse.setDspId(DspEnum.DSP_17.getDspId());

        List<CommonSeatBid> commonSeatBids = seatBidConvert(bidResponse.getSeatbid());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatBidConvert(List<SeatBid> seatbid) {
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        SeatBid seatBid = seatbid.get(0);
        List<Bid> bidList = seatBid.getBid();
        Bid bid = bidList.get(0);
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        commonSeatBid.setPrice((double) bid.getPrice());
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        List<String> nurls = new ArrayList<>();
        nurls.add(bid.getNurl());
        commonSeatBid.setWinCallbackUrls(nurls);
        commonSeatBid.setExposureCallbackUrls(bid.getImp_trackers());
        commonSeatBid.setClickCallbackUrls(bid.getClick_trackers());
        Adm adm = bid.getAdm();
        if (StringUtils.isNotBlank(adm.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank(adm.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (adm.getExt() != null && StringUtils.isNotBlank(adm.getExt().getIcon())) {
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(adm.getExt().getIcon());
            commonCreative.setCommonIcon(commonIcon);
        }
        if (adm.getVideo() != null) {
            List<CommonVideo> commonVideoList = new ArrayList<>();
            CommonVideo commonVideo = new CommonVideo();
            Video video = adm.getVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setResolutionX(video.getW());
            commonVideo.setResolutionY(video.getH());
            if (CollectionUtils.isNotEmpty(adm.getImg())) {
                Image image = adm.getImg().get(0);
                commonVideo.setCoverUrl(image.getUrl());
                commonVideo.setCoverHeight(image.getH());
                commonVideo.setCoverWidth(image.getW());
            }
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        } else if (CollectionUtils.isNotEmpty(adm.getImg())) {
            List<CommonImage> commonImageList = new ArrayList<>();
            for (Image image : adm.getImg()) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image.getUrl());
                commonImage.setHeight(image.getH());
                commonImage.setWidth(image.getW());
                commonImageList.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImageList);
        }
        commonCreative.setLandingPageUrl(adm.getLand());
        commonCreative.setDeepLinkUrl(adm.getDplink());
        if (adm.getApp() != null) {
            commonCreative.setAppName(adm.getApp().getName());
            commonCreative.setAppBundle(adm.getApp().getPackage_name());
        }

        commonSeatBidList.add(commonSeatBid);
        return commonSeatBidList;
    }
}
