package cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.converter;

import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.BidStatService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.JinghongProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.bean.Jinghong;
import cn.com.duiba.tuia.dsp.engine.api.util.BigDataUaUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2022/9/30
 * @Description 汇川请求转换器
 **/
@Component
@Slf4j
public class JinghongRequestConverter {
    @Autowired
    private AppReplace appReplace;

    @Resource
    private JinghongProperties jinghongProperties;
    @Autowired
    private BidStatService bidStatService;


    public Jinghong.AdRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Jinghong.AdRequest adRequest = new Jinghong.AdRequest();
        adRequest.setVersion(jinghongProperties.getVersion());
        adRequest.setClientAdRequestId(adxCommonBidRequest.getRequestId());

        // 转换广告位信息（Imp）
        adRequest.setMultislot(this.convertImp(adxCommonBidRequest, dspInfo));

        // 转换应用信息（App）
        adRequest.setApp(this.convertApp(adxCommonBidRequest, dspInfo));

        // 设备信息
        adRequest.setDevice(convertDevice(adxCommonBidRequest));

        // 网络信息
        Jinghong.Network network = new Jinghong.Network();
        network.setType(this.convertConnectionType(adxCommonBidRequest.getDevice().getTuiaConnectionType()));
        network.setCarrier(this.convertCarrier(adxCommonBidRequest.getDevice().getCarrier()));
        adRequest.setNetwork(network);

        // Geo
        Jinghong.Geo geo = new Jinghong.Geo();
        CommonGeo commonGeo = adxCommonBidRequest.getDevice().getGeo();
        if (commonGeo != null) {
            geo.setLat(geo.getLat());
            geo.setLon(geo.getLon());
            adRequest.setGeo(geo);
        }

        return adRequest;
    }

    /**
     * 转换应用信息（考虑App替换逻辑）
     */
    private Jinghong.App convertApp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Jinghong.App adAppInfo = new Jinghong.App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());

        if (replaceApp != null) {
            adAppInfo.setName(replaceApp.getName());
            adAppInfo.setVersion(replaceApp.getVersion());
            adAppInfo.setPkgname(replaceApp.getBundle());
            return adAppInfo;
        }

        adAppInfo.setName(appInfo.getName());
        adAppInfo.setPkgname(appInfo.getBundle());
        adAppInfo.setVersion(appInfo.getVersion());
        adAppInfo.setLang("zh");
        adAppInfo.setCountry("CN");
        return adAppInfo;
    }

    /**
     * 转换设备信息
     */
    private Jinghong.Device convertDevice(AdxCommonBidRequest adxCommonBidRequest) {
        Jinghong.Device adDeviceInfo = new Jinghong.Device();
        CommonDevice device = adxCommonBidRequest.getDevice();
        adDeviceInfo.setType(4);//表示手机
        adDeviceInfo.setUseragent(device.getUa());
        BigDataUaUtils.UserAgentDto userAgentDto = BigDataUaUtils.parseUserAgent(device.getUa());
        adDeviceInfo.setOs("Android");
        adDeviceInfo.setVersion(device.getOsVersion());
        if ("华为".equals(device.getMake())) {
            adDeviceInfo.setMaker("HUAWEI");
        } else if ("荣耀".equals(device.getModel())) {
            adDeviceInfo.setMaker("HONOR");
        } else {
            adDeviceInfo.setMaker(device.getMake());
        }
        if (userAgentDto != null) {
            adDeviceInfo.setModel(userAgentDto.getPhoneModel());
        } else {
            adDeviceInfo.setModel(device.getModel());
        }
        adDeviceInfo.setImei(device.getImei());
        adDeviceInfo.setOaid(device.getOaId());
        if (StringUtils.isNotBlank(adDeviceInfo.getOaid())) {
            adDeviceInfo.setIsTrackingEnabled("1");
        }
        adDeviceInfo.setAndroidid(device.getDpId());
        adDeviceInfo.setIp(device.getIp());
        adDeviceInfo.setVerCodeOfAG(device.getAgVerCode());
        adDeviceInfo.setVerCodeOfHms(device.getHmsCoreVersion());
        adDeviceInfo.setWidth(device.getScreenWidth());
        adDeviceInfo.setHeight(device.getScreenHeight());
        adDeviceInfo.setDpi(device.getPpi());
        adDeviceInfo.setBelongCountry("CN");
        String clientTime = DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss.SSSZ");
        adDeviceInfo.setClientTime(clientTime);
        return adDeviceInfo;
    }

    /**
     * 转换广告位信息
     */
    private List<Jinghong.AdSlot> convertImp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        ResourceIdeaDto resourceIdeaByCache = bidStatService.getResourceIdeaByCache(String.valueOf(dspInfo.getIdeaId()));
        List<CommonImp> impList = adxCommonBidRequest.getImpList();
        if (CollectionUtils.isEmpty(impList)) return Lists.newArrayList();
        List<Jinghong.AdSlot> adSlots = Lists.newArrayListWithCapacity(impList.size());
        for (CommonImp commonImp : impList) {
            Jinghong.AdSlot adSlot = new Jinghong.AdSlot();
            adSlot.setSlotid(dspInfo.getDspTagId());
            CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
            if (appInfo != null && resourceIdeaByCache != null && StringUtils.isNotBlank(resourceIdeaByCache.getDspTagIdJson())) {
                String bundle = appInfo.getBundle();
                JSONObject dspTagIdJson = JSONObject.parseObject(resourceIdeaByCache.getDspTagIdJson());
                String dspTagId = dspTagIdJson.getString(bundle);
                if (StringUtils.isNotBlank(dspTagId)) {
                    adSlot.setSlotid(dspTagId);
                }
            }


            //1：开屏广告
            //3：原生广告
            //7：激励视频
            //8：Banner
            //12：插屏
            //60：视频贴片广告
            adSlot.setAdtype(Integer.parseInt(dspInfo.getDspResId()));
            if (adSlot.getAdtype().equals(1)) {
                adSlot.setOrientation(1);
            }
            adSlot.setTest(0);
            long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
            adSlot.setBidfloor((float) floorPrice);
            if (CollectionUtils.isNotEmpty(commonImp.getFilteringSize())) {
                CommonSizeInfo sizeInfo = commonImp.getFilteringSize().get(0);
                adSlot.setTotalDuration(sizeInfo.getMaxduration());
            }
            adSlots.add(adSlot);
        }

        return adSlots;
    }

    private int convertConnectionType(Integer connectionType) {
        //网络类型 0：其他；1：WIFI；2：2G；3：3G；4：4G；5：5G
        if (connectionType == null) return 0;
        switch (connectionType) {
            case 1:
                return 2;
            case 2:
                return 4;
            case 3:
                return 5;
            case 4:
                return 6;
            case 5:
                return 7;
        }
        return 0;
    }

    private int convertCarrier(String carrier) {
        if (carrier == null) return 0;
        switch (carrier) {
            case "1":
                return 2; // 移动
            case "2":
                return 1; // 联通
            case "3":
                return 3; // 电信
            default:
                return 99;   // 其它
        }
    }
}
