package cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp;

import lombok.Data;

@Data
public class CommonCallbackRequest {
    /**
     * 回调类型
     */
    private Integer type;


    //广告实际视图宽
    private int adW;
    private int adH;
    //屏幕密度
    private int dpi;
    // 屏幕点击坐标（按下和抬起）
    private int screenClickDownX;   // 屏幕点击按下时的X坐标
    private int screenClickDownY;   // 屏幕点击按下时的Y坐标
    private int screenClickUpX;     // 屏幕点击抬起时的X坐标
    private int screenClickUpY;     // 屏幕点击抬起时的Y坐标

    // 广告区域点击坐标（按下和抬起）
    private int adClickDownX;       // 广告区域点击按下时的X坐标
    private int adClickDownY;       // 广告区域点击按下时的Y坐标
    private int adClickUpX;         // 广告区域点击抬起时的X坐标
    private int adClickUpY;         // 广告区域点击抬起时的Y坐标

    // 时间戳（毫秒）
    private long timeStamp;      // 事件发生时间戳

    // 广告交互方式
    private int activeSlide;        // 广告交互类型：0-常规点击，1-滑动点击，2-摇一摇，5-扭一扭，6-擦除

    // 摇一摇加速度数据（ACTIVE_SLD=2时使用）
    private int shakeMaxAccelX;     // X轴最大加速度（100倍取整）
    private int shakeMaxAccelY;     // Y轴最大加速度（100倍取整）
    private int shakeMaxAccelZ;     // Z轴最大加速度（100倍取整）

    // 扭一扭角度数据（ACTIVE_SLD=3或4时使用）
    private int twistTurnX;         // X轴扭动角度（-180°~180°）
    private int twistTurnY;         // Y轴扭动角度（-180°~180°）
    private int twistTurnZ;         // Z轴扭动角度（-180°~180°）
    private int twistTurnTime;      // 扭动持续时间（毫秒）
}
