package cn.com.duiba.tuia.dsp.engine.api.util;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * UAUtils
 */
public class UAUtils {
    
    private static final Logger logger     = LoggerFactory.getLogger(UAUtils.class);

    public static final String MODEL_IPHONE = "iPhone";

    private static final Pattern PATTERN_IPHONE  = Pattern.compile("\\((iPhone);(.+?)\\)");    // iPhone
    private static final Pattern PATTERN_ANDROID = Pattern.compile(";\\s?(((\\d|[a-z]|[A-Z]|-|_)*?\\s)*?)(Build)?/"); // Android

    private static final Pattern HARMONYOS  = Pattern.compile("HarmonyOS;\\s?(\\S*)");
    private static final Pattern HARMONYOS2  = Pattern.compile(";\\s?(\\S*); HMSCore");
    private UAUtils(){
    }
    
    /**
     * parseUA
     * 
     * @param userAgent
     * @return UAData
     */
    public static UAData parseUA(String userAgent){
        if(StringUtils.isBlank(userAgent)){
            return new UAData();
        }
        UAData data = new UAData();
        data.setUa(userAgent);
        try {
            // IOS
            Matcher iphoneMatcher = PATTERN_IPHONE.matcher(userAgent);
            if (iphoneMatcher.find()) {
                data.setOsType("iOS");
                data.setModel(MODEL_IPHONE);
                data.setVendor("apple");
                return data;
            }

            // Android
            Matcher androidMatcher = PATTERN_ANDROID.matcher(userAgent);
            if (androidMatcher.find() && androidMatcher.groupCount() > 0) {
                String model = androidMatcher.group(1).trim();
                data.setOsType("Android");
                data.setModel(model);
                data.setVendor(null);
                return data;
            }
            Matcher HarmonyMatcher = HARMONYOS.matcher(userAgent);
            if(HarmonyMatcher.find()){
                String model = HarmonyMatcher.group(1).trim();
                data.setOsType("Android");
                data.setModel(model);
                data.setVendor(null);
                return data;
            }
            Matcher HarmonyMatcher1 = HARMONYOS2.matcher(userAgent);
            if(HarmonyMatcher1.find()){
                String model = HarmonyMatcher1.group(1).trim();
                data.setOsType("Android");
                data.setModel(model);
                data.setVendor(null);
                return data;
            }
        } catch(Exception e) {
            System.out.println("异常ua》》》》" + userAgent);
            logger.warn("Parse ua failed.", e);
        }
        return data;
    }

}
