/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangBidding;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class QiHangRespConvert {
    public AdxCommonBidResponse convert(QiHangBidding.BidResponse bidResponse) {
        if (bidResponse == null) {
            return null;
        }
        List<QiHangBidding.BidResponse.SeatBid> seatBidList = bidResponse.getSeatBidList();
        if (CollectionUtils.isEmpty(seatBidList)) {
            return null;
        }
        AdxCommonBidResponse response = new AdxCommonBidResponse();
        response.setRequestId(bidResponse.getId());
        response.setDspId(DspEnum.DSP_10.getDspId());
        QiHangBidding.BidResponse.SeatBid seatBid = seatBidList.get(0);
        QiHangBidding.BidResponse.Bid bid = seatBid.getBid(0);
        CommonSeatBid commonSeatBid = this.bidConvert(bid);
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        commonSeatBidList.add(commonSeatBid);
        response.setCommonSeatBidList(commonSeatBidList);
        return response;
    }

    private CommonSeatBid bidConvert(QiHangBidding.BidResponse.Bid bid) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBid.setPrice(Double.valueOf(bid.getPrice()));
        String nurl = bid.getNurl();
        commonSeatBid.setWinCallbackUrls(Collections.singletonList(nurl));
        ArrayList<String> exposureUrls = new ArrayList<String>((Collection<String>)bid.getClkTrackersList());
        commonSeatBid.setExposureCallbackUrls(exposureUrls);
        ArrayList<String> clkUrls = new ArrayList<String>((Collection<String>)bid.getClkTrackersList());
        commonSeatBid.setClickCallbackUrls(clkUrls);
        CommonCreative commonCreative = new CommonCreative();
        commonCreative.setAppName(bid.getAppName());
        commonCreative.setAppBundle(bid.getPackageName());
        commonCreative.setIconUrl(bid.getIconUrl());
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(bid.getIconUrl());
        commonCreative.setCommonIcon(commonIcon);
        QiHangBidding.BidResponse.Bid.Adm adm = bid.getAdm();
        if (StringUtils.isNotBlank((CharSequence)adm.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (adm.hasVideo()) {
            QiHangBidding.BidResponse.Bid.Adm.Video video = adm.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getVideoUrl());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            commonVideo.setSize(video.getSize());
            commonVideo.setUnit("Byte");
            commonVideo.setCoverUrl(adm.getCoverImgUrl());
            commonVideo.setCoverWidth(video.getWidth());
            commonVideo.setCoverHeight(video.getHeight());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            List<QiHangBidding.BidResponse.Bid.Adm.Image> imageList = adm.getImageList();
            ArrayList<CommonImage> commonImages = new ArrayList<CommonImage>(imageList.size());
            for (QiHangBidding.BidResponse.Bid.Adm.Image image2 : imageList) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image2.getUrl());
                commonImage.setWidth(image2.getWidth());
                commonImage.setHeight(image2.getHeight());
                commonImages.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImages);
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getDeepLink())) {
            commonCreative.setDeepLinkUrl(adm.getDeepLink());
        }
        if (StringUtils.isNotBlank((CharSequence)adm.getUniversalLink())) {
            commonCreative.setULinkUrl(adm.getUniversalLink());
        }
        commonCreative.setLandingPageUrl(adm.getLandingSite());
        commonSeatBid.setCommonCreative(commonCreative);
        return commonSeatBid;
    }
}

