package cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req;

import lombok.Data;

import java.util.List;

@Data
public class Device {
    //设备UA信息
    private String ua;
    //设备出口网络IP，ipv4或ipv6都行
    private String ip;
    //ipv6
    private String ipv6;
    //设备类型
    //0-未知
    //1-手机/平板
    //2-pc
    //3-tv
    private int deviceType;
    //手机品牌
    private String make;
    //Y	手机型号
    //如：iPhoneX, KNT-AL10
    private String model;
    private String idfa;
    private String idfaMd5;
    private String oaid;
    private String oaidMd5;
    private String imei;
    private String imeiMd5;
    private String os;
    private String osv;
    //运营商
    //0：未知
    //1：中国移动
    //2：中国联通
    //3：中国电信
    private int carrier;
    //网络连接状态
    //0：未知
    //1：Ethernet以太网
    //2：WIFI 网络
    //3：蜂窝数据网络 - 未知
    //4：蜂窝数据网络 - 2G
    //5：蜂窝数据网络 - 3G
    //6：蜂窝数据网络 - 4G
    //7：蜂窝数据网络 - 5G
    private int connectionType;
    //caid版本，如果传caid，该版本字段必传，比如20220111版本，目前只支持20220111版本
    private String caidVersion;
    //caid原始值
    private String caid;
    //caidInfo
    private List<CaidInfo> caidInfos;
    //系统启动时间
    private String bootMark;
    //系统更新时间
    private String updateMark;
    //Android Id原始值
    private String androidId;
    //Android Id md5值
    private String androidIdMd5;
}
