/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.convert.FeiSuoAppConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.proto.FeiSuoProtoBid;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeiSuoDspReqConvert {
    @Autowired
    private AppReplace appReplace;

    public FeiSuoProtoBid.FlyingShuttleBidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        List<Integer> installedApps;
        FeiSuoProtoBid.FlyingShuttleBidRequest.Builder builder = FeiSuoProtoBid.FlyingShuttleBidRequest.newBuilder();
        builder.setToken("1yh0ryt83i0czmcsugsk98q64kr7g24u");
        builder.setRequestId(adxCommonBidRequest.getRequestId());
        builder.setTimestamp(System.currentTimeMillis());
        CommonUserInfo userInfo = adxCommonBidRequest.getUserInfo();
        if (userInfo != null && CollectionUtils.isNotEmpty(userInfo.getAppList()) && CollectionUtils.isNotEmpty(installedApps = this.convertInstallApp(userInfo.getAppList()))) {
            FeiSuoProtoBid.User.Builder user = FeiSuoProtoBid.User.newBuilder();
            user.addAllInstalledApps(installedApps);
            builder.setUser(user);
        }
        List<CommonImp> commonImps = adxCommonBidRequest.getImpList();
        CommonImp commonImp = commonImps.get(0);
        FeiSuoProtoBid.Slot slot = this.convertSlot(commonImp, dspInfo);
        builder.setSlot(slot);
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        FeiSuoProtoBid.Device device = this.convertDevice(commonDevice);
        builder.setDevice(device);
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        FeiSuoProtoBid.SourceApp sourceApp = this.convertAppInfo(appInfo, dspInfo);
        builder.setApp(sourceApp);
        FeiSuoProtoBid.Network.Builder network = this.convertNetwork(commonDevice);
        builder.setNetwork(network);
        CommonGeo commonGeo = commonDevice.getGeo();
        if (commonGeo != null) {
            builder.setGeo(this.convertGeo(commonGeo));
        }
        return builder.build();
    }

    private FeiSuoProtoBid.Geo convertGeo(CommonGeo commonGeo) {
        FeiSuoProtoBid.Geo.Builder geo = FeiSuoProtoBid.Geo.newBuilder();
        geo.setLatitude(commonGeo.getLat());
        geo.setLongitude(commonGeo.getLon());
        return geo.build();
    }

    private FeiSuoProtoBid.Network.Builder convertNetwork(CommonDevice commonDevice) {
        FeiSuoProtoBid.Network.Builder network = FeiSuoProtoBid.Network.newBuilder();
        Integer tuiaConnectionType = commonDevice.getTuiaConnectionType();
        network.setType(FeiSuoProtoBid.NetType.NET_TYPE_UNSPECIFIED);
        if (tuiaConnectionType != null) {
            if (tuiaConnectionType == 1) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_ETHERNET);
            }
            if (tuiaConnectionType == 2) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_WIFI);
            }
            if (tuiaConnectionType == 3) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_CELLULAR_UNKNOWN);
            }
            if (tuiaConnectionType == 4) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_CELLULAR_2G);
            }
            if (tuiaConnectionType == 5) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_CELLULAR_3G);
            }
            if (tuiaConnectionType == 6) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_CELLULAR_4G);
            }
            if (tuiaConnectionType == 7) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_CELLULAR_5G);
            }
        }
        String carrier = commonDevice.getCarrier();
        network.setCarrier(FeiSuoProtoBid.Carrier.CARRIER_UNSPECIFIED);
        if (StringUtils.isNotBlank((CharSequence)carrier)) {
            if ("1".equals(carrier)) {
                network.setCarrier(FeiSuoProtoBid.Carrier.CARRIER_MOBILE);
            } else if ("2".equals(carrier)) {
                network.setCarrier(FeiSuoProtoBid.Carrier.CARRIER_UNICOM);
            } else if ("3".equals(carrier)) {
                network.setCarrier(FeiSuoProtoBid.Carrier.CARRIER_TELECOM);
            }
        }
        network.setIpv4(commonDevice.getIp());
        return network;
    }

    private FeiSuoProtoBid.SourceApp convertAppInfo(CommonAppInfo appInfo, DspInfo dspInfo) {
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        FeiSuoProtoBid.SourceApp.Builder app = FeiSuoProtoBid.SourceApp.newBuilder();
        if (replaceApp != null) {
            appInfo = replaceApp;
        }
        app.setName(appInfo.getName());
        app.setPkgName(appInfo.getBundle());
        return app.build();
    }

    private FeiSuoProtoBid.Device convertDevice(CommonDevice commonDevice) {
        String os;
        FeiSuoProtoBid.Device.Builder builder = FeiSuoProtoBid.Device.newBuilder();
        Integer tuiaDeviceType = commonDevice.getTuiaDeviceType();
        if (tuiaDeviceType != null) {
            builder.setType(FeiSuoProtoBid.DeviceType.DEVICE_TYPE_UNSPECIFIED);
            if (tuiaDeviceType == 1) {
                builder.setType(FeiSuoProtoBid.DeviceType.DEVICE_TYPE_PHONE);
            }
            if (tuiaDeviceType == 2) {
                builder.setType(FeiSuoProtoBid.DeviceType.DEVICE_TYPE_PC);
            }
            if (tuiaDeviceType == 3) {
                builder.setType(FeiSuoProtoBid.DeviceType.DEVICE_TYPE_TV);
            }
        }
        if ("1".equals(os = commonDevice.getOs())) {
            builder.setOs(FeiSuoProtoBid.OS.OS_IOS);
        } else if ("0".equals(os)) {
            builder.setOs(FeiSuoProtoBid.OS.OS_ANDROID);
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOsVersion())) {
            builder.setOsVersion(commonDevice.getOsVersion());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getMake())) {
            builder.setVendor(commonDevice.getMake());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getModel())) {
            builder.setModel(commonDevice.getModel());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getUa())) {
            builder.setUserAgent(commonDevice.getUa());
        }
        builder.setScreenWidth(commonDevice.getScreenWidth());
        builder.setScreenHeight(commonDevice.getScreenHeight());
        builder.setScreenPpi(commonDevice.getPpi());
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getBootTime())) {
            builder.setBootTime(commonDevice.getBootTime());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getUpdateTime())) {
            builder.setSysUpdateTime(commonDevice.getUpdateTime());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getHmsCoreVersion())) {
            builder.setHwHmsVerCode(commonDevice.getHmsCoreVersion());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getAgVerCode())) {
            builder.setHwAgVerCode(commonDevice.getAgVerCode());
        }
        FeiSuoProtoBid.DeviceID.Builder deviceID = FeiSuoProtoBid.DeviceID.newBuilder();
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getImei())) {
            deviceID.setImei(commonDevice.getImei());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getDpId())) {
            deviceID.setAndroidId(commonDevice.getDpId());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getMac())) {
            deviceID.setMac(commonDevice.getMac());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOaId())) {
            deviceID.setOaid(commonDevice.getOaId());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getIdFa())) {
            deviceID.setIdfa(commonDevice.getIdFa());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOaIdMd5())) {
            deviceID.setOaidMd5(commonDevice.getOaIdMd5());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getImeiMd5())) {
            deviceID.setImeiMd5(commonDevice.getImeiMd5());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getIdFaMd5())) {
            deviceID.setIdfaMd5(commonDevice.getIdFaMd5());
        }
        if (CollectionUtils.isNotEmpty(commonDevice.getCaids())) {
            for (Caid caid : commonDevice.getCaids()) {
                FeiSuoProtoBid.CAID.Builder caidBuilder = FeiSuoProtoBid.CAID.newBuilder();
                caidBuilder.setCaid(caid.getId());
                caidBuilder.setVersion(caid.getVersion());
                deviceID.addCaids(caidBuilder);
            }
        }
        return builder.build();
    }

    private FeiSuoProtoBid.Slot convertSlot(CommonImp commonImp, DspInfo dspInfo) {
        FeiSuoProtoBid.Slot.Builder builder = FeiSuoProtoBid.Slot.newBuilder();
        builder.setId(dspInfo.getDspTagId());
        builder.setType(FeiSuoProtoBid.SlotType.forNumber(Integer.parseInt(dspInfo.getDspResId())));
        builder.setAdCount(1);
        builder.addMaterialTypes(FeiSuoProtoBid.MaterialType.forNumber(Integer.parseInt(dspInfo.getDspTemplateId())));
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        builder.setFloorCpm((int)floorPrice);
        return builder.build();
    }

    private List<Integer> convertInstallApp(List<String> appList) {
        return appList.stream().map(FeiSuoAppConvert::convert).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

