/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.BidStatService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.CaidInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.Icon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.Image;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.Imp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.Video;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TuiaReqConvert {
    @Autowired
    private AppReplace appReplace;
    @Autowired
    private ApolloPanGuService apolloPanGuService;
    @Autowired
    private BidStatService bidStatService;

    public BidRequest convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        BidRequest request = new BidRequest();
        request.setId(adxCommonBidRequest.getRequestId());
        Imp imp = this.impConvert(adxCommonBidRequest, dspInfo);
        request.setImp(imp);
        App app = this.appConvert(adxCommonBidRequest, dspInfo);
        request.setApp(app);
        Device device = this.deviceConvert(adxCommonBidRequest, dspInfo);
        request.setDevice(device);
        if (Objects.equals(adxCommonBidRequest.getHttpProtocol(), 1)) {
            request.setSecure(1);
        }
        return request;
    }

    private Device deviceConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Device device = new Device();
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        device.setUa(commonDevice.getUa());
        device.setIp(commonDevice.getIp());
        device.setDeviceType(commonDevice.getDeviceType() == null ? 0 : commonDevice.getDeviceType());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfaMd5(commonDevice.getIdFaMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaidMd5(commonDevice.getOaIdMd5());
        device.setImei(commonDevice.getImei());
        device.setImeiMd5(commonDevice.getImeiMd5());
        device.setOs(commonDevice.getOs());
        device.setOsv(commonDevice.getOsVersion());
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getCarrier())) {
            device.setCarrier(Integer.parseInt(commonDevice.getCarrier()));
        }
        if (commonDevice.getTuiaConnectionType() != null) {
            device.setConnectionType(commonDevice.getTuiaConnectionType());
        }
        List<Caid> caids = commonDevice.getCaids();
        ArrayList<CaidInfo> caidInfos = new ArrayList<CaidInfo>();
        if (CollectionUtils.isNotEmpty(caids)) {
            for (Caid caid : caids) {
                if (caid.getVersion().equals("20220111")) {
                    device.setCaid(caid.getId());
                    device.setCaidVersion(caid.getVersion());
                }
                CaidInfo caidInfo = new CaidInfo();
                caidInfo.setCaid(caid.getId());
                caidInfo.setVersion(caid.getVersion());
                caidInfos.add(caidInfo);
            }
            device.setCaidInfos(caidInfos);
        }
        device.setBootMark(commonDevice.getBootTime());
        device.setUpdateMark(commonDevice.getUpdateTime());
        device.setAndroidId(commonDevice.getDpId());
        device.setAndroidIdMd5(commonDevice.getDpIdMd5());
        return device;
    }

    private App appConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        App app = new App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setId(replaceApp.getId());
            app.setName(replaceApp.getName());
            app.setBundle(replaceApp.getBundle());
        } else {
            if (appInfo.getName() != null) {
                app.setName(appInfo.getName());
            }
            app.setId(appInfo.getId());
            app.setBundle(appInfo.getBundle());
            app.setVersion(appInfo.getVersion());
        }
        CommonUserInfo userInfo = adxCommonBidRequest.getUserInfo();
        if (Objects.nonNull(userInfo)) {
            app.setUserTags(userInfo.getUserTags());
            app.setInstallApps(userInfo.getAppList());
        }
        return app;
    }

    public Imp impConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Imp imp = new Imp();
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        imp.setId(1);
        imp.setSlotType(Integer.parseInt(dspInfo.getDspResId()));
        imp.setPid(dspInfo.getDspTagId());
        if (DspEnum.DSP_25.getDspId().equals(dspInfo.getDspId())) {
            ResourceIdeaDto resourceIdeaByCache = this.bidStatService.getResourceIdeaByCache(String.valueOf(dspInfo.getIdeaId()));
            CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
            if (appInfo != null && resourceIdeaByCache != null && StringUtils.isNotBlank((CharSequence)resourceIdeaByCache.getDspTagIdJson())) {
                String bundle = appInfo.getBundle();
                JSONObject dspTagIdJson = JSONObject.parseObject((String)resourceIdeaByCache.getDspTagIdJson());
                String dspTagId = dspTagIdJson.getString(bundle);
                if (StringUtils.isNotBlank((CharSequence)dspTagId)) {
                    imp.setPid(dspTagId);
                }
            }
        }
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        imp.setBidFloor((int)floorPrice);
        imp.setBidType(0);
        List<CommonSizeInfo> filteringSize = commonImp.getFilteringSize();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            if (Objects.equals(commonSizeInfo.getType(), 1)) {
                Image image2 = new Image();
                if (DspEnum.DSP_25.getDspId().equals(dspInfo.getDspId()) && imp.getSlotType() == 1) {
                    image2.setWidth(1080);
                    image2.setHeight(1920);
                } else {
                    image2.setWidth(commonSizeInfo.getWidth());
                    image2.setHeight(commonSizeInfo.getHeight());
                }
                imp.setImage(image2);
            }
            if (!Objects.equals(commonSizeInfo.getType(), 3)) continue;
            Video video = new Video();
            if (DspEnum.DSP_25.getDspId().equals(dspInfo.getDspId()) && imp.getSlotType() == 3) {
                video.setWidth(720);
                video.setHeight(1280);
                video.setMinDuration(commonSizeInfo.getMinduration());
                video.setMaxDuration(commonSizeInfo.getMaxduration());
                video.setCoverWidth(720);
                video.setCoverHeight(1280);
            } else {
                video.setWidth(commonSizeInfo.getWidth());
                video.setHeight(commonSizeInfo.getHeight());
                video.setCoverWidth(commonSizeInfo.getWidth());
                video.setCoverHeight(commonSizeInfo.getHeight());
                video.setMinDuration(commonSizeInfo.getMinduration());
                video.setMaxDuration(commonSizeInfo.getMaxduration());
            }
            imp.setVideo(video);
        }
        Icon icon = new Icon();
        icon.setWidth(100);
        icon.setHeight(100);
        imp.setIcon(icon);
        imp.setNeedTitle(1);
        imp.setMaxTitle(15);
        imp.setNeedDesc(1);
        imp.setMaxDesc(30);
        ArrayList<Integer> promotionTypes = new ArrayList<Integer>();
        promotionTypes.add(1);
        promotionTypes.add(2);
        if (commonImp.isOpenDeepLink()) {
            promotionTypes.add(3);
            imp.setOpenDeepLink(true);
        }
        if (commonImp.isOpenQuickApp()) {
            promotionTypes.add(4);
            imp.setOpenQuickApp(true);
        }
        commonImp.setPromotionTypes(promotionTypes);
        return imp;
    }
}

