package cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.bean;

import lombok.Data;

import java.util.List;
import java.util.Map;

public final class Jinghong {

    @Data
    public static final class AdRequest {

        private String version;
        private List<AdSlot> multislot;
        private App app;
        private Device device;
        private Network network;
        private Integer tmax;
        private String clientAdRequestId;
        private Integer parentCtrlUser;
        private Integer nonPersonalizedAd;
        private Regs regs;
        private Geo geo;
        private String consent;
        private String[] cur;
        private Integer hwDspNpa;
        private Integer thirdDspNpa;
    }

    @Data
    public static final class AdSlot {

        private String slotid;
        private Integer adtype;
        private Integer test;
        private Float bidfloor;
        private String bidfloorcur;
        private List<String> bpkgname;
        private Integer totalDuration;
        private Integer orientation;
    }

    @Data
    public static final class App {

        private String version;
        private String name;
        private String pkgname;
        private String lang;
        private String country;
    }

    @Data
    public static final class Device {

        private Integer type;
        private String useragent;
        private String os;
        private String version;
        private String maker;
        private String model;
        private Integer width;
        private Integer height;
        private String language;
        private String buildVersion;
        private Integer dpi;
        private Float pxratio;
        private String imei;
        private String oaid;
        private String androidid;
        private String isTrackingEnabled;
        private String emuiVer;
        private String localeCountry;
        private String simCountryIso;
        private String belongCountry;
        private String gaidTrackingEnabled;
        private String gaid;
        private String verCodeOfHms;
        private String clientTime;
        private String verCodeOfAG;
        private String vendorCountry;
        private String roLocaleCountry;
        private String agCountryCode;
        private String routerCountry;
        private String roLocale;
        private String ip;
    }

    @Data
    public static final class Network {

        private Integer type;
        private Integer carrier;
        private List<CellInfo> cellInfo;
    }

    @Data
    public static final class CellInfo {

        private String mcc;
        private String mnc;
    }

    @Data
    public static final class Regs  {

        private Integer coppa;
        private Integer tfua;
        private String adRating;
    }

    @Data
    public static final class Geo {

        private Float lon;
        private Float lat;
        private Integer accuracy;
        private Integer lastfix;
    }

    @Data
    public static final class AdResponse {

        private Integer retcode;
        private String reason;
        private List<Ad> multiad;
        private Integer dspcost;
    }

    @Data
    public static final class Ad {

        private String slotid;
        private Integer retcode30;
        private List<Content> content;
    }

    @Data
    public static final class Content  {

        private String contentid;
        private Long endtime;
        private Integer interactiontype;
        private Integer creativetype;
        private String nurl;
        private String lurl;
        private MetaData metaData;
        private Long starttime;
        private List<String> keyWords;
        private List<String> keyWordsType;
        private List<Monitor> monitor;
        private List<Integer> filterList;
        private Integer sequence;
        private RewardItem rewardItem;
        private String whyThisAd;
        private String cur;
        private Float price;
    }

    @Data
    public static final class MetaData {

        private String title;
        private List<ImageInfo> imageInfo;
        private String clickUrl;
        private String label;
        private String intent;
        private VideoInfo videoInfo;
        private ApkInfo apkInfo;
        private Long duration;
        private MediaFile mediaFile;
        private String rewardCriterion;
        private String screenOrientation;
        private String privacyUrl;
        private PromoteInfo promoteInfo;
        private String miniProgramLink;
        private String miniProgramId;
    }

    @Data
    public static final class ImageInfo {

        private String url;
        private Integer width;
        private Integer height;
        private Integer fileSize;
        private String sha256;
        private String imageType;
    }

    @Data
    public static final class VideoInfo {

        private String videoDownloadUrl;
        private Integer videoDuration;
        private Integer videoFileSize;
        private String sha256;
        private Float videoRatio;
    }

    @Data
    public static final class Monitor {

        private String eventType;
        private List<String> url;
    }

    @Data
    public static final class ApkInfo {

        private String url;
        private String versionCode;
        private Long fileSize;
        private String sha256;
        private String packageName;
        private String secondUrl;
        private String appName;
        private List<Permission> permissions;
        private String versionName;
        private String appDesc;
        private String appIcon;
        private String developerName;
        private String permissionUrl;
        private String detailUrl;
    }

    @Data
    public  static final class Permission {

        private String permissionLabel;
        private String groupDesc;
        private String targetSDK;
    }

    @Data
    public static final class MediaFile {

        private String mime;
        private Integer width;
        private Integer height;
        private Long fileSize;
        private String url;
        private String sha256;
    }

    /**
     * 奖励物品类
     */
    @Data
    public static final class RewardItem {

        private String type;
        private Integer amount;
    }

    /**
     * 推广信息类
     */
    @Data
    public static final class PromoteInfo{

        private Integer type;
        private String name;
    }
}
