package cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.Bid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.RuiShiReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.RuiShiRsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.convert.RuiShiReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.convert.RuiShiRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import com.google.doubleclick.crypto.DoubleClickCrypto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;

@Slf4j
@Component
public class RuiShiDspInvoker extends AbstractDspCaller<RuiShiRsp, RuiShiReq> {
    public static DoubleClickCrypto.Price clickCrypto = null;
    public static final byte[] KEY1 = "b8459ad37b619125b7125026d8005f5a".getBytes();
    public static final byte[] KEY2 = "77c589c81cd026c8170bbf7c1a16c857".getBytes();

    @Autowired
    private RuiShiReqConvert reqConvert;

    @Autowired
    private RuiShiRespConvert respConvert;

    @Autowired
    private RuiShiProperties ruiShiProperties;

    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;

    static {
        try {
            DoubleClickCrypto.Keys keys = new DoubleClickCrypto.Keys(
                    new SecretKeySpec(KEY1, "HmacSHA1"),
                    new SecretKeySpec(KEY2, "HmacSHA1")
            );
            clickCrypto = new DoubleClickCrypto.Price(keys);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected RuiShiRsp invokeDsp(RuiShiReq ruiShiReq) {
        if (ruiShiReq == null) {
            return null;
        }
        Cat.logMetricForCount("瑞狮DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(ruiShiProperties.getUrl(), ruiShiReq), "invokeDSP", "ruishi");
        } catch (Throwable t) {
            if (!(t instanceof SocketTimeoutException || t instanceof ResourceAccessException)) {
                SamplerLog.warn("瑞狮调用异常", t);
            }
        }
        return null;
    }

    private RuiShiRsp doHttpInvoke(String url, RuiShiReq ruiShiReq) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "application/json");
        HttpEntity<RuiShiReq> requestEntity = new HttpEntity<>(ruiShiReq, headers);
        ResponseEntity<JSONObject> exchange = null;
        try {
            exchange = restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class);
        } catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn("瑞狮调用异常", e);
            }
            return null;
        }

        SamplerLog.info("瑞狮 返回 {}", exchange);
        JSONObject body = exchange.getBody();
        if (body == null) {
            return null;
        }
        Integer code = body.getInteger("code");
        if (code == 204) {
            return null;
        }
        Cat.logMetricForCount("瑞狮DSP返回");
        String id = body.getString("id");
        String bidid = body.getString("bidid");
        RuiShiRsp rsp = new RuiShiRsp();
        rsp.setCode(code);
        rsp.setId(id);
        rsp.setBidid(bidid);
        JSONObject seatbid = body.getJSONArray("seatbid").getJSONObject(0);
        JSONObject bidObj = seatbid.getJSONArray("bid").getJSONArray(0).getJSONObject(0);
        ;
        Bid bid = JSONObject.parseObject(bidObj.toJSONString(), Bid.class);
        rsp.setBid(bid);
        return rsp;
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        if (price == null) {
            price = BigDecimal.ZERO;
        }
        return clickCrypto.encodePriceMicros(price.longValue(),
                null);
    }


    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_11.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_11;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${AUCTION_PRICE}") && price != null) {
            url = url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public RuiShiReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {

        return reqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(RuiShiRsp ruiShiRsp) throws DspException {
        if (ruiShiRsp == null) {
            return null;
        }

        return respConvert.convert(ruiShiRsp);
    }
}
