package cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean.BuLuKenBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import com.google.protobuf.ProtocolStringList;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Component
@Slf4j
public class BuLuKenResponseConvert {
    public AdxCommonBidResponse respConvert(BuLuKenBidResponse response) {
        if (response == null) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_6.getDspId());
        List<CommonSeatBid> commonSeatBids = seatConvert(response.getSeatbid().getBid());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<BuLuKenBidResponse.Bid> seatList) {
        List<CommonSeatBid> commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        BuLuKenBidResponse.Bid bid = seatList.get(0);
        if(Objects.nonNull(bid)){
            commonSeatBid.setPrice(Double.valueOf(bid.getPrice()));
            commonSeatBid.setAdvertiserId("");//todo ?
            commonSeatBid.setWinCallbackUrls(Collections.singletonList(bid.getNurl()));
            commonCreative.setLandingPageUrl(bid.getTarget());
            commonCreative.setCreativeId(bid.getId());
            commonCreative.setDeepLinkUrl(bid.getDeeplink());
            context.setDeepLinkUrl(bid.getDeeplink());


            BuLuKenBidResponse.Events events = bid.getEvents();
            if(Objects.nonNull(events)){
                commonSeatBid.setExposureCallbackUrls(events.getImp_urls());
                commonSeatBid.setClickCallbackUrls(events.getClick_urls());
            }

            BuLuKenBidResponse.Admobject admobject = bid.getAdmobject();
            if(Objects.nonNull(admobject)){
                if(Objects.nonNull(admobject.getNativeObj())){
                    if(CollectionUtils.isNotEmpty(admobject.getNativeObj().getAssets())){
                        List<BuLuKenBidResponse.Asset> assets = admobject.getNativeObj().getAssets();
                        assets.forEach(asset -> {
                            if(Objects.nonNull(asset.getTitle())){
                                CommonTitle commonTitle = new CommonTitle();
                                commonTitle.setTitle(asset.getTitle().getText());
                                commonCreative.setCommonTitle(commonTitle);
                            }
                            if(Objects.nonNull(asset.getImg())){
                                List<CommonImage> imageList = new ArrayList<>();
                                CommonImage image = new CommonImage();
                                image.setUrl(asset.getImg().getUrl());
                                image.setWidth(asset.getImg().getW());
                                image.setHeight(asset.getImg().getH());
                                imageList.add(image);
                                commonCreative.setCommonImageList(imageList);
                            }
                            if(Objects.nonNull(asset.getVideo())){
                                List<CommonVideo> videoList = new ArrayList<>();
                                CommonVideo video = new CommonVideo();
                                video.setVideoUrl(asset.getVideo().getUrl());
                                video.setDuration(BigDecimal.valueOf(asset.getVideo().getDuration()));
                                video.setCoverUrl(asset.getVideo().getCover());
                                videoList.add(video);
                                commonCreative.setCommonVideoList(videoList);
                            }
                        });
                        if (Objects.isNull(commonCreative.getCommonTitle())) {
                            CommonTitle commonTitle = new CommonTitle();
                            commonTitle.setTitle("惊喜");
                            commonCreative.setCommonTitle(commonTitle);
                        }
                    }
                }
            }

        }

        return commonSeatBidList;
    }
}
