/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.converter;

import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.BidStatService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.JinghongProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.bean.Jinghong;
import cn.com.duiba.tuia.dsp.engine.api.util.BigDataUaUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JinghongRequestConverter {
    private static final Logger log = LoggerFactory.getLogger(JinghongRequestConverter.class);
    @Autowired
    private AppReplace appReplace;
    @Resource
    private JinghongProperties jinghongProperties;
    @Autowired
    private BidStatService bidStatService;

    public Jinghong.AdRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Jinghong.AdRequest adRequest = new Jinghong.AdRequest();
        adRequest.setVersion(this.jinghongProperties.getVersion());
        adRequest.setClientAdRequestId(adxCommonBidRequest.getRequestId());
        adRequest.setMultislot(this.convertImp(adxCommonBidRequest, dspInfo));
        adRequest.setApp(this.convertApp(adxCommonBidRequest, dspInfo));
        adRequest.setDevice(this.convertDevice(adxCommonBidRequest));
        Jinghong.Network network = new Jinghong.Network();
        network.setType(this.convertConnectionType(adxCommonBidRequest.getDevice().getTuiaConnectionType()));
        network.setCarrier(this.convertCarrier(adxCommonBidRequest.getDevice().getCarrier()));
        adRequest.setNetwork(network);
        Jinghong.Geo geo = new Jinghong.Geo();
        CommonGeo commonGeo = adxCommonBidRequest.getDevice().getGeo();
        if (commonGeo != null) {
            geo.setLat(geo.getLat());
            geo.setLon(geo.getLon());
            adRequest.setGeo(geo);
        }
        return adRequest;
    }

    private Jinghong.App convertApp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Jinghong.App adAppInfo = new Jinghong.App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            adAppInfo.setName(replaceApp.getName());
            adAppInfo.setVersion(replaceApp.getVersion());
            adAppInfo.setPkgname(replaceApp.getBundle());
            return adAppInfo;
        }
        adAppInfo.setName(appInfo.getName());
        adAppInfo.setPkgname(appInfo.getBundle());
        adAppInfo.setVersion(appInfo.getVersion());
        adAppInfo.setLang("zh");
        adAppInfo.setCountry("CN");
        return adAppInfo;
    }

    private Jinghong.Device convertDevice(AdxCommonBidRequest adxCommonBidRequest) {
        Jinghong.Device adDeviceInfo = new Jinghong.Device();
        CommonDevice device = adxCommonBidRequest.getDevice();
        adDeviceInfo.setType(4);
        adDeviceInfo.setUseragent(device.getUa());
        BigDataUaUtils.UserAgentDto userAgentDto = BigDataUaUtils.parseUserAgent(device.getUa());
        adDeviceInfo.setOs("Android");
        adDeviceInfo.setVersion(device.getOsVersion());
        if ("\u534e\u4e3a".equals(device.getMake())) {
            adDeviceInfo.setMaker("HUAWEI");
        } else if ("\u8363\u8000".equals(device.getModel())) {
            adDeviceInfo.setMaker("HONOR");
        } else {
            adDeviceInfo.setMaker(device.getMake());
        }
        if (userAgentDto != null) {
            adDeviceInfo.setModel(userAgentDto.getPhoneModel());
        } else {
            adDeviceInfo.setModel(device.getModel());
        }
        adDeviceInfo.setImei(device.getImei());
        adDeviceInfo.setOaid(device.getOaId());
        if (StringUtils.isNotBlank((CharSequence)adDeviceInfo.getOaid())) {
            adDeviceInfo.setIsTrackingEnabled("1");
        }
        adDeviceInfo.setAndroidid(device.getDpId());
        adDeviceInfo.setIp(device.getIp());
        adDeviceInfo.setVerCodeOfAG(device.getAgVerCode());
        adDeviceInfo.setVerCodeOfHms(device.getHmsCoreVersion());
        adDeviceInfo.setWidth(device.getScreenWidth());
        adDeviceInfo.setHeight(device.getScreenHeight());
        adDeviceInfo.setDpi(device.getPpi());
        adDeviceInfo.setBelongCountry("CN");
        String clientTime = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss.SSSZ");
        adDeviceInfo.setClientTime(clientTime);
        return adDeviceInfo;
    }

    private List<Jinghong.AdSlot> convertImp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        ResourceIdeaDto resourceIdeaByCache = this.bidStatService.getResourceIdeaByCache(String.valueOf(dspInfo.getIdeaId()));
        List<CommonImp> impList = adxCommonBidRequest.getImpList();
        if (CollectionUtils.isEmpty(impList)) {
            return Lists.newArrayList();
        }
        ArrayList adSlots = Lists.newArrayListWithCapacity((int)impList.size());
        for (CommonImp commonImp : impList) {
            Jinghong.AdSlot adSlot = new Jinghong.AdSlot();
            adSlot.setSlotid(dspInfo.getDspTagId());
            CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
            if (appInfo != null && resourceIdeaByCache != null && StringUtils.isNotBlank((CharSequence)resourceIdeaByCache.getDspTagIdJson())) {
                String bundle = appInfo.getBundle();
                JSONObject dspTagIdJson = JSONObject.parseObject((String)resourceIdeaByCache.getDspTagIdJson());
                String dspTagId = dspTagIdJson.getString(bundle);
                if (StringUtils.isNotBlank((CharSequence)dspTagId)) {
                    adSlot.setSlotid(dspTagId);
                }
            }
            adSlot.setAdtype(Integer.parseInt(dspInfo.getDspResId()));
            if (adSlot.getAdtype().equals(1)) {
                adSlot.setOrientation(1);
            }
            adSlot.setTest(0);
            long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
            adSlot.setBidfloor(Float.valueOf(floorPrice));
            if (CollectionUtils.isNotEmpty(commonImp.getFilteringSize())) {
                CommonSizeInfo sizeInfo = commonImp.getFilteringSize().get(0);
                adSlot.setTotalDuration(sizeInfo.getMaxduration());
            }
            adSlots.add(adSlot);
        }
        return adSlots;
    }

    private int convertConnectionType(Integer connectionType) {
        if (connectionType == null) {
            return 0;
        }
        switch (connectionType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
        }
        return 0;
    }

    private int convertCarrier(String carrier) {
        if (carrier == null) {
            return 0;
        }
        switch (carrier) {
            case "1": {
                return 2;
            }
            case "2": {
                return 1;
            }
            case "3": {
                return 3;
            }
        }
        return 99;
    }
}

