package cn.com.duiba.tuia.dsp.engine.api.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

/**
 * DSP限流配置
 *
 * @author lizhiheng
 */
@Configuration("RateLimiterProperties")
@ConfigurationProperties(prefix = "dsp.rate.limiter")
@Data
@RefreshScope
public class RateLimiterProperties {
    /**
     * guava.rateLimiter默认每秒钟发牌数
     */
    public Integer tokenPerSec = 5;
    /**
     * guava.rateLimiter获取令牌超时时间，单位为《微秒》
     */
    private Integer requireTimeout = 1000;
    /**
     * 一个CompletableFuture的超时时间,单位为《毫秒》
     */
    private Integer futureTimeOut = 1000;
}