package cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean.BuLuKenBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.*;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Component
@Slf4j
public class BuLuKenRequestConvert {
    @Autowired
    private AppReplace appReplace;

    /**
     * 图片类型
     */
    private static final Integer BANNER_TYPTE = 1;
    /**
     * 视频类型
     */
    private static final Integer VIDEO_TYPE = 3;

    public BuLuKenBidRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        BuLuKenBidRequest builder = new BuLuKenBidRequest();
        builder.setVersion("2.4");
        builder.setId(adxCommonBidRequest.getRequestId());
        convertImp(builder, adxCommonBidRequest, dspInfo);
        convertApp(builder, adxCommonBidRequest, dspInfo);
        convertDevice(builder, adxCommonBidRequest);
        return builder;
    }

    public void convertImp(BuLuKenBidRequest builder, AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {

        BuLuKenBidRequest.Imp imp = new BuLuKenBidRequest.Imp();
        builder.setImp(Collections.singletonList(imp));
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        imp.setId(commonImp.getId());
        imp.setIsdeeplink(true);
        List<CommonSizeInfo> filteringSize = filter(commonImp.getFilteringSize(), dspInfo.getAdStyleList());

        if (CollectionUtils.isNotEmpty(filteringSize)) {
            CommonSizeInfo commonSizeInfo = filteringSize.get(0);

            if (dspInfo.getDspTagId() != null) {
                imp.setTagid(dspInfo.getDspTagId());
            }

            Integer type = commonSizeInfo.getType();

            if (BANNER_TYPTE.equals(type)) {
                BuLuKenBidRequest.Native bannerBuilder = new BuLuKenBidRequest.Native();
                if (StringUtils.isNotBlank(dspInfo.getDspTemplateId())) {
                    bannerBuilder.setLayout(Integer.valueOf(dspInfo.getDspTemplateId()));
                }
                BuLuKenBidRequest.Native.Asset asset = new BuLuKenBidRequest.Native.Asset();
                BuLuKenBidRequest.Native.Img img = new BuLuKenBidRequest.Native.Img();
                img.setWmin(commonSizeInfo.getWidth());
                img.setHmin(commonSizeInfo.getHeight());
                img.setType(3);

                //设置banner对象
                bannerBuilder.setAssets(Collections.singletonList(asset));
                asset.setImg(img);
                asset.setId(1);
                asset.setIsrequired(1);
                imp.setNativeObj(bannerBuilder);

            } else if (VIDEO_TYPE.equals(type)) {
                BuLuKenBidRequest.Video videoBuilder = new BuLuKenBidRequest.Video();
                videoBuilder.setW(commonSizeInfo.getWidth());
                videoBuilder.setH(commonSizeInfo.getHeight());
                videoBuilder.setType(1);
                videoBuilder.setMimes(Collections.singletonList("video/mp4"));
                videoBuilder.setMinduration(Optional.ofNullable(commonSizeInfo.getMinduration()).orElse(5));
                videoBuilder.setMaxduration(Optional.ofNullable(commonSizeInfo.getMaxduration()).orElse(30));

                //设置video对象
                imp.setVideo(videoBuilder);
            } else {
                log.warn("布鲁肯dsp convertImp 无法识别是banner 还是 video");
            }
        }

        imp.setBidfloor((double) Math.round(commonImp.getFloorPrice()) + 1);

    }

    public final String ANDROID = "0";
    public final String IOS = "1";

    public String getOsType(String os) {
        if (StringUtils.isBlank(os)) {
            return "unknown";
        }
        switch (os) {
            case ANDROID:
                return "Android";
            case IOS:
                return "iOS";
            default:
                return "unknown";
        }
    }

    //移动
    public static final String MOVE = "1";
    //联通
    public static final String UNICOM = "2";
    //电信
    public static final String TELECOM = "3";

    public String getCarrierType(String carrier) {
        if (StringUtils.isBlank(carrier)) {
            return "mobile";
        }
        switch (carrier) {
            case MOVE:
                return "mobile";
            case UNICOM:
                return "unicom";
            case TELECOM:
                return "telecom";
            default:
                return "mobile";
        }
    }

    public void convertDevice(BuLuKenBidRequest request, AdxCommonBidRequest adxCommonBidRequest) {
        BuLuKenBidRequest.Device builder = new BuLuKenBidRequest.Device();
        CommonDevice device = adxCommonBidRequest.getDevice();
        builder.setIp(device.getIp());
        builder.setUa(device.getUa());
        if (StringUtils.isNotEmpty(device.getImeiMd5())) {
            builder.setDidmd5(StringUtils.upperCase(device.getImeiMd5()));
        }
        if (StringUtils.isNotEmpty(device.getOaIdMd5())) {
            builder.setOidmd5(StringUtils.upperCase(device.getOaIdMd5()));
        }
        if (StringUtils.isNotEmpty(device.getIdFaMd5())) {
            builder.setIfamd5(StringUtils.upperCase(device.getIdFaMd5()));
        }
        if (StringUtils.isNotEmpty(device.getOaId())) {
            builder.setOid(device.getOaId());
        }
        builder.setDevicetype(0);
        builder.setMake(device.getMake());
        builder.setModel(device.getModel());
        builder.setOs(OsConvert.getOsType(device.getOs()));
        builder.setOsv(device.getOsVersion());
        builder.setCarrier(getCarrierType(device.getCarrier()));
        builder.setConnectiontype(device.getTuiaConnectionType());
        request.setDevice(builder);
    }

    public void convertApp(BuLuKenBidRequest request, AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        BuLuKenBidRequest.App builder = new BuLuKenBidRequest.App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            String bundle = replaceApp.getBundle();
            String name = replaceApp.getName();
            builder.setBundle(bundle);
            builder.setName(name);
        } else {
            builder.setBundle(appInfo.getBundle());
            builder.setName(appInfo.getName());
        }
        builder.setVersion(appInfo.getVersion());
        request.setApp(builder);
    }

    private List<CommonSizeInfo> filter(List<CommonSizeInfo> filteringSize, List<FilterMaterInfo> filterMaterInfos) {
        if (CollectionUtils.isEmpty(filteringSize) || CollectionUtils.isEmpty(filterMaterInfos)) {
            return null;
        }
        List<CommonSizeInfo> commonSizeInfos = Lists.newArrayList();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            CommonSizeInfo commonSizeInfo1 = matchSizeInfo(filterMaterInfos, commonSizeInfo);
            if (Objects.nonNull(commonSizeInfo1)) {
                commonSizeInfos.add(commonSizeInfo1);
            }

        }
        return commonSizeInfos;
    }

    private CommonSizeInfo matchSizeInfo(List<FilterMaterInfo> filterMaterInfos, CommonSizeInfo commonSizeInfo) {
        int width = commonSizeInfo.getWidth();
        int height = commonSizeInfo.getHeight();
        for (FilterMaterInfo filterMaterInfo : filterMaterInfos) {
            if (filterMaterInfo.getWidth().equals(width) && filterMaterInfo.getHeight().equals(height)) {
                return commonSizeInfo;
            }
        }
        return null;
    }
}
