package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.adx.center.api.dto.IdeaPriceStrategyDTO;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;


/**
 * 门面接口
 *
 * @author lizhiheng
 */
public abstract class DspFacadeInterface {

    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    private CalculatorCpmService calculatorCpmService;
    @Autowired
    private BidStatService bidStatService;

    /**
     * 调用DSP接口的门面方法
     * 需要传入公共请求参数和外部dsp接口
     * doInvoke接口做了
     * 1。异步请求所需的外部dsp调用
     * 2。进行比价
     * 3。返回 x
     *
     * @param adxCommonBidRequest
     * @param dspInfos
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     * @throws TimeoutException
     */
    abstract AdxCommonBidResponse doInvoke(AdxCommonBidRequest adxCommonBidRequest, List<DspInfo> dspInfos) throws ExecutionException, InterruptedException, TimeoutException;

    /**
     * 比价方法，
     *
     * @param responseList
     * @return
     */
    protected AdxCommonBidResponse comparePrice(List<AdxCommonBidResponse> responseList) {
        if (Objects.isNull(responseList) || responseList.isEmpty()) {
            return null;
        }
        double maxPrice = 0;
        AdxCommonBidResponse maxPriceResponse = null;
        for (AdxCommonBidResponse adxCommonBidResponse : responseList) {
            CommonSeatBid commonSeatBid = adxCommonBidResponse.getCommonSeatBidList().get(0);
            ResourceIdeaDto resourceIdeaDto = bidStatService.getResourceIdeaByCache(String.valueOf(adxCommonBidResponse.getIdeaId()));
            if (resourceIdeaDto == null) {
                continue;
            }
            Integer ideaPriceType = resourceIdeaDto.getPriceType();
            Integer chargeType = resourceIdeaDto.getChargeType();
            //0-推啊出价 1-dsp出价
            Integer priceMode = resourceIdeaDto.getPriceMode();

            if (chargeType == 0 && priceMode == 0) {
                //固价
                if (ideaPriceType == 0) {
                    commonSeatBid.setPrice(resourceIdeaDto.getIdeaPriceStrategyDTO().getExpectPrice() * 100);
                }
                //基于底价
                if (ideaPriceType == 1) {
                    AdxCommonBidRequest commonBidRequest = commonSeatBid.getCommonBidRequest();
                    List<CommonImp> impList = commonBidRequest.getImpList();
                    double floorPrice = impList.get(0).getFloorPrice();
                    commonSeatBid.setPrice(floorPrice + resourceIdeaDto.getIdeaPriceStrategyDTO().getExpectPrice() * 100);
                }
            }

            //cpm比较出价 直接使用cpm出价
            if (chargeType == 0) {
                commonSeatBid.setCompareCpm(commonSeatBid.getPrice());
            }

            //cpc dsp出价 换算成cpm出价
            if (ideaPriceType == 2 && priceMode == 1 && chargeType == 4) {
                double compareCpm = calculatorCpmService.cpc2Cpm(commonSeatBid.getPrice(), adxCommonBidResponse);
                SamplerLog.info("dsp comparePrice cpc2Cpm ideaid {} price is {}", adxCommonBidResponse.getIdeaId(), compareCpm);
                commonSeatBid.setCompareCpm(compareCpm);
            }

            //推啊固定cpc出价 换算成cpm出价
            if (ideaPriceType == 2 && priceMode == 0 && chargeType == 4) {
                IdeaPriceStrategyDTO ideaPriceStrategyDTO = resourceIdeaDto.getIdeaPriceStrategyDTO();
                Double price = ideaPriceStrategyDTO.getExpectPrice() * 100;
                double compareCpm = calculatorCpmService.cpc2Cpm(price, adxCommonBidResponse);
                SamplerLog.info("dsp comparePrice cpc2Cpm ideaid {} price is {}", adxCommonBidResponse.getIdeaId(), compareCpm);
                commonSeatBid.setPrice(price);
                commonSeatBid.setCompareCpm(compareCpm);
            }

            //推啊ocpc出价 换算成cpm出价
            if (chargeType == 5) {
                double compareCpm = calculatorCpmService.calculateOcpc(resourceIdeaDto, adxCommonBidResponse);
                SamplerLog.info("dsp comparePrice ocpc ideaid {} compateCpm is {} cpcPrice is {}", adxCommonBidResponse.getIdeaId(), compareCpm, commonSeatBid.getPrice());
                commonSeatBid.setCompareCpm(compareCpm);
            }

            //推啊ocpm出价 计算出cpm出价
            if (chargeType == 3) {
                double compareCpm = calculatorCpmService.calculateOcpm(adxCommonBidResponse);
                SamplerLog.info("dsp comparePrice calculateOcpm ideaid {} price is {}", adxCommonBidResponse.getIdeaId(), compareCpm);
                commonSeatBid.setCompareCpm(compareCpm);
                commonSeatBid.setPrice(compareCpm);
            }

            //媒体ocpm出价
            if (ideaPriceType == 3) {
                double compareCpm = calculatorCpmService.calculateOcpm(adxCommonBidResponse);
                SamplerLog.info("dsp comparePrice calculateOcpm ideaid {} price is {}", adxCommonBidResponse.getIdeaId(), compareCpm);
                commonSeatBid.setCompareCpm(compareCpm);
                IdeaPriceStrategyDTO ideaPriceStrategyDTO = resourceIdeaDto.getIdeaPriceStrategyDTO();
                Double price = ideaPriceStrategyDTO.getExpectPrice() * 100;
                commonSeatBid.setPrice(price);
            }

            if (commonSeatBid.getCompareCpm() > maxPrice) {
                maxPrice = commonSeatBid.getCompareCpm();
                maxPriceResponse = adxCommonBidResponse;
            }
        }

        return maxPriceResponse;
    }

    /**
     * 价格加密方法
     *
     * @param price
     * @param dspId
     * @return
     */
    public abstract String priceEncryption(BigDecimal price, Integer dspId);

    /**
     * 宏替换含有价格的url
     *
     * @param price 出价价格
     * @param dspId 外部dsp id
     * @param url   需要替换的url
     * @return
     */
    public abstract String replaceUrl(String price, String url, Integer dspId);

    /**
     * 竞价胜出回调广告主
     *
     * @param url   回调链接
     * @param dspId
     */
    public abstract void doWinCallBack(String url, Integer dspId);

    /**
     * 点击回调广告主
     *
     * @param url   回调链接
     * @param dspId
     */
    public abstract void doClickCallBack(String url, Integer dspId);

    /**
     * 曝光回调广告主
     *
     * @param url   回调链接
     * @param dspId
     */
    public abstract void doExposureCallBack(String url, Integer dspId);

}
