package cn.com.duiba.tuia.dsp.engine.api.dsp.common.req;

import lombok.Data;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * Description: 广告位信息
 *
 * @author xierongli
 * @create 2019-11-18 17:11
 */
@Data
public class CommonImp {

    // Id
    private String id;

    // 模版
    private String impTemplate;

    // 模版Id,软告需要透传
    private String impTemplateId;

    //广告位Id
    private String tagId;
    //广告位索引
    private Integer tagIndex;
    //广告位宽
    private Integer w;
    //广告位高
    private Integer h;

    //推广类型
    private List<Integer> contentTypes;
    //竞价方式(1-CPM 2-CPC)
    private Integer bidType;

    //广告位底价(单位:分)
    private double floorPrice;

    //cpc底价(单位：分)
    private int cpcFloorPrice;

    // 链接协议 ( 返回给媒体的链接协议 ,如: 落地页、物料图片、视频等 ) { true : https , false : http }
    private boolean linkAgreement;

    // 广告位类型 , 参考: AdSlotTypeEnum
    private int adSlotType;

    /**
     * 过滤尺寸
     * 注: 尺寸 or 时长不支持同时过滤.
     */
    private List<CommonSizeInfo> filteringSize;
    /**
     * 开启过滤的广告位 Id 集合.
     * 注: 未设置过滤默认关闭.
     */
    private List<String> filteringTagIdSet;


    /**
     * 竞价请求是否开启deepLink
     */
    private boolean openDeepLink;

    /**
     * 是否支持快应用
     */
    private boolean openQuickApp;

    /**
     * 支持推广类型 1.落地页 2.应用下载
     * 3.deeplink 4.快应用
     */
    private List<Integer> promotionTypes;

    /**
     * 外部广告位ID
     */
    private String externalAdBlockId;


    private String ext;


}
