/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.bean.Jinghong;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class JinghongResponseConverter {
    public AdxCommonBidResponse respConvert(Jinghong.AdResponse rtbResponse) {
        if (Objects.isNull(rtbResponse)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_24.getDspId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(rtbResponse.getMultiad(), rtbResponse.getDspcost());
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<Jinghong.Ad> adList, Integer dspcost) {
        ArrayList commonSeatBidList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(adList)) {
            return commonSeatBidList;
        }
        Jinghong.Ad firstAd = adList.get(0);
        List<Jinghong.Content> adContentList = firstAd.getContent();
        String soltId = firstAd.getSlotid();
        for (Jinghong.Content adContent : adContentList) {
            List<Jinghong.ImageInfo> images;
            Jinghong.VideoInfo video;
            Jinghong.MetaData metaData = adContent.getMetaData();
            Integer interactiontype = adContent.getInteractiontype();
            CommonSeatBid commonSeatBid = new CommonSeatBid();
            CommonContext commonContext = new CommonContext();
            commonSeatBid.setCommonContext(commonContext);
            commonSeatBid.setAdvertiserId("44910");
            CommonCreative commonCreative = new CommonCreative();
            commonCreative.setMaterialId(adContent.getContentid());
            commonSeatBid.setPrice(adContent.getPrice() != null ? Double.valueOf(adContent.getPrice().floatValue()) : 0.0);
            CommonTitle commonTitle = new CommonTitle();
            commonCreative.setCommonTitle(commonTitle);
            Jinghong.ApkInfo apkInfo = metaData.getApkInfo();
            if (apkInfo != null) {
                commonCreative.setAppBundle(apkInfo.getPackageName());
                commonCreative.setIconUrl(apkInfo.getAppIcon());
                commonCreative.setPrivacyPolicyLink(metaData.getPrivacyUrl());
                commonCreative.setPermissionLink(apkInfo.getPermissionUrl());
                commonCreative.setAppVersion(apkInfo.getVersionCode());
                commonCreative.setIconUrl(apkInfo.getAppIcon());
                commonCreative.setDeveloper(apkInfo.getDeveloperName());
                CommonIcon commonIcon = new CommonIcon();
                commonIcon.setUrl(apkInfo.getAppIcon());
                commonCreative.setCommonIcon(commonIcon);
                CommonDesc commonDesc = new CommonDesc();
                try {
                    if (StringUtils.isNotBlank((String)apkInfo.getAppName())) {
                        commonCreative.setAppName(URLDecoder.decode(apkInfo.getAppName(), "UTF-8"));
                    }
                    if (StringUtils.isNotBlank((String)apkInfo.getAppDesc())) {
                        commonDesc.setDesc(URLDecoder.decode(apkInfo.getAppDesc(), "UTF-8"));
                    }
                    if (StringUtils.isNotBlank((String)metaData.getTitle())) {
                        commonTitle.setTitle(URLDecoder.decode(metaData.getTitle(), "UTF-8"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                commonCreative.setCommonDesc(commonDesc);
                if (interactiontype == 2) {
                    commonCreative.setDownloadUrl(apkInfo.getUrl());
                }
                if (apkInfo.getAppDesc() != null) {
                    try {
                        commonCreative.setAppFeature(URLDecoder.decode(apkInfo.getAppDesc(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
            if (metaData.getIntent() != null) {
                try {
                    String intent = metaData.getIntent();
                    if (StringUtils.isNotBlank((String)intent)) {
                        String dbLink = intent;
                        if (!intent.startsWith("hwpps://landingpage")) {
                            dbLink = URLDecoder.decode(metaData.getIntent(), "UTF-8");
                        }
                        commonCreative.setDeepLinkUrl(dbLink);
                        commonContext.setDeepLinkUrl(dbLink);
                        commonSeatBid.setCommonContext(commonContext);
                    }
                }
                catch (Exception intent) {
                    // empty catch block
                }
            }
            commonCreative.setLandingPageUrl(metaData.getClickUrl());
            if (StringUtils.isBlank((String)commonCreative.getLandingPageUrl())) {
                commonCreative.setLandingPageUrl("https://developer.huawei.com/consumer/cn/huawei-quickApp");
            }
            if ((video = metaData.getVideoInfo()) != null) {
                CommonVideo commonVideo = new CommonVideo();
                commonVideo.setVideoUrl(video.getVideoDownloadUrl());
                commonVideo.setDuration(new BigDecimal(video.getVideoDuration() / 1000));
                commonVideo.setSize(video.getVideoFileSize());
                commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
                if (CollectionUtils.isNotEmpty(metaData.getImageInfo())) {
                    Jinghong.ImageInfo imageInfo = metaData.getImageInfo().get(0);
                    commonVideo.setCoverUrl(imageInfo.getUrl());
                    commonVideo.setCoverWidth(imageInfo.getWidth());
                    commonVideo.setCoverHeight(imageInfo.getHeight());
                }
            }
            if (CollectionUtils.isNotEmpty(images = metaData.getImageInfo())) {
                ArrayList commonImageList = Lists.newArrayList();
                for (Jinghong.ImageInfo image2 : images) {
                    CommonImage commonImage = new CommonImage();
                    commonImage.setUrl(image2.getUrl());
                    commonImage.setWidth(image2.getWidth());
                    commonImage.setHeight(image2.getHeight());
                    commonImage.setSize(image2.getFileSize());
                    commonImageList.add(commonImage);
                }
                commonCreative.setCommonImageList(commonImageList);
            }
            List<Jinghong.Monitor> monitors = adContent.getMonitor();
            commonSeatBid.setWinCallbackUrls(Collections.singletonList(adContent.getNurl()));
            for (Jinghong.Monitor monitor : monitors) {
                switch (monitor.getEventType()) {
                    case "imp": {
                        commonSeatBid.setExposureCallbackUrls(monitor.getUrl());
                        break;
                    }
                    case "click": {
                        commonSeatBid.setClickCallbackUrls(monitor.getUrl());
                        break;
                    }
                    case "downloadstart": {
                        commonSeatBid.setStartDownloadUrls(monitor.getUrl());
                        break;
                    }
                    case "download": {
                        commonSeatBid.setFinishDownloadUrls(monitor.getUrl());
                        break;
                    }
                    case "install": {
                        commonSeatBid.setFinishInstallUrls(monitor.getUrl());
                        break;
                    }
                    case "intentSuccess": {
                        commonSeatBid.setDeeplinkSuccessUrls(monitor.getUrl());
                        break;
                    }
                    case "userclose": {
                        commonSeatBid.setCloseAdUrls(monitor.getUrl());
                        break;
                    }
                    case "appOpen": {
                        commonSeatBid.setAppOpenUrls(monitor.getUrl());
                    }
                }
            }
            commonSeatBid.setCommonCreative(commonCreative);
            commonSeatBidList.add(commonSeatBid);
        }
        return commonSeatBidList;
    }
}

