/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.convert;

import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.BidStatService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.proto.BaiDuDsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaiDuDspReqConvert {
    @Autowired
    private BidStatService bidStatService;
    @Autowired
    private AppReplace appReplace;

    public BaiDuDsp.Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        List<String> appList;
        BaiDuDsp.Request.Builder request = BaiDuDsp.Request.newBuilder();
        request.setReqId(adxCommonBidRequest.getRequestId());
        request.setAt(1);
        request.setSecure(1);
        if (Objects.equals(adxCommonBidRequest.getHttpProtocol(), 1)) {
            request.setSecure(0);
        }
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        BaiDuDsp.Imp.Builder imp = this.convertImp(commonImp, appInfo, dspInfo);
        request.addImp(imp);
        BaiDuDsp.App.Builder app = this.convertApp(appInfo, dspInfo);
        request.setApp(app);
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        BaiDuDsp.Device.Builder device = this.convertDevice(commonDevice);
        request.setDevice(device);
        CommonUserInfo userInfo = adxCommonBidRequest.getUserInfo();
        if (userInfo != null && CollectionUtils.isNotEmpty(appList = userInfo.getAppList())) {
            device.addAllInstalledApp(appList);
        }
        return request.build();
    }

    private BaiDuDsp.Device.Builder convertDevice(CommonDevice commonDevice) {
        String ip;
        BaiDuDsp.Device.Builder device = BaiDuDsp.Device.newBuilder();
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getUa())) {
            device.setUa(commonDevice.getUa());
        }
        if ((ip = commonDevice.getIp()).contains(":")) {
            device.setIpv6(ip);
        } else {
            device.setIp(ip);
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getMake())) {
            device.setMake(commonDevice.getMake());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getModel())) {
            device.setModel(commonDevice.getModel());
        }
        Integer deviceType = commonDevice.getTuiaDeviceType();
        String os = commonDevice.getOs();
        if ("0".equals(os)) {
            device.setOs("Android");
            if (deviceType != null && deviceType == 1) {
                device.setDeviceType(1);
            }
        } else if ("1".equals(os)) {
            device.setOs("IOS");
            if (deviceType != null && deviceType == 1) {
                device.setDeviceType(2);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOsVersion())) {
            device.setOsv(commonDevice.getOsVersion());
        }
        String carrier = commonDevice.getCarrier();
        device.setCarrier(0);
        if ("2".equals(carrier)) {
            device.setCarrier(3);
        }
        if ("3".equals(carrier)) {
            device.setCarrier(2);
        }
        if ("1".equals(carrier)) {
            device.setCarrier(1);
        }
        Integer tuiaConnectionType = commonDevice.getTuiaConnectionType();
        device.setNetwork(0);
        if (tuiaConnectionType != null) {
            if (2 == tuiaConnectionType) {
                device.setNetwork(1);
            }
            if (4 == tuiaConnectionType) {
                device.setNetwork(2);
            }
            if (5 == tuiaConnectionType) {
                device.setNetwork(3);
            }
            if (6 == tuiaConnectionType) {
                device.setNetwork(4);
            }
            if (7 == tuiaConnectionType) {
                device.setNetwork(5);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getIdFa())) {
            device.setIdfa(commonDevice.getIdFa());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getIdFaMd5())) {
            device.setIdfaMd5(commonDevice.getIdFaMd5());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getImei())) {
            device.setImei(commonDevice.getImei());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getImeiMd5())) {
            device.setImeiMd5(commonDevice.getImeiMd5());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOaId())) {
            device.setOaid(commonDevice.getOaId());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOaIdMd5())) {
            device.setOaidMd5(commonDevice.getOaIdMd5());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getDpId())) {
            device.setAndroidId(commonDevice.getDpId());
        }
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getDpIdMd5())) {
            device.setAndroidIdMd5(commonDevice.getDpIdMd5());
        }
        if (CollectionUtils.isNotEmpty(commonDevice.getCaids())) {
            commonDevice.getCaids().forEach(caid -> {
                BaiDuDsp.Device.CAID.Builder caidBuilder = BaiDuDsp.Device.CAID.newBuilder();
                caidBuilder.setCaid(caid.getId());
                caidBuilder.setVer(caid.getVersion());
                device.addCaids(caidBuilder);
            });
        }
        device.setWidth(commonDevice.getScreenWidth());
        device.setHeight(commonDevice.getScreenHeight());
        return device;
    }

    private BaiDuDsp.App.Builder convertApp(CommonAppInfo appInfo, DspInfo dspInfo) {
        BaiDuDsp.App.Builder app = BaiDuDsp.App.newBuilder();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setName(replaceApp.getName());
            app.setBundle(replaceApp.getBundle());
        } else {
            app.setName(appInfo.getName());
            app.setBundle(appInfo.getBundle());
        }
        return app;
    }

    private BaiDuDsp.Imp.Builder convertImp(CommonImp commonImp, CommonAppInfo appInfo, DspInfo dspInfo) {
        BaiDuDsp.Imp.Builder imp = BaiDuDsp.Imp.newBuilder();
        imp.setId(commonImp.getId());
        imp.setSlotType(dspInfo.getDspResId());
        imp.addTemplateIds(dspInfo.getDspTemplateId());
        int floorPrice = (int)CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        String bundle = appInfo.getBundle();
        String tagId = bundle + dspInfo.getDspResId() + dspInfo.getDspTagId();
        imp.setAdslotId(tagId);
        ResourceIdeaDto resourceIdeaDto = this.bidStatService.getResourceIdeaByCache(String.valueOf(dspInfo.getIdeaId()));
        int bidMod = 1;
        if (resourceIdeaDto != null && resourceIdeaDto.getPriceType() == 2 || dspInfo.getCpcCharge() == 1) {
            imp.setCpcBidfloor(floorPrice);
            imp.setBidMod(bidMod << 1);
        } else {
            imp.setBidfloor(floorPrice);
        }
        return imp;
    }
}

