package cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.bean.Guangtui;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.converter.GuangtuiResponseConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.converter.GunagtuiRequestConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.google.protobuf.util.JsonFormat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.REQ_PARAM_CONVERT_ERROR;
import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.RESP_PARAM_CONVERT_ERROR;

/**
 * @Author yuquanfeng
 * @Date 2022/9/30
 * @Description
 * @Param
 * @return
 **/
@Component
@Slf4j
public class GuangtuiDspInvoker extends AbstractDspCaller<Guangtui.Response, Guangtui.Request> {

    @Resource
    private GunagtuiRequestConverter guangtuiRequestConverter;

    @Resource
    private GuangtuiResponseConverter guangtuiResponseConverter;

    @Resource
    private GuangtuiProperties guangtuiProperties;

    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Override
    protected Guangtui.Response invokeDsp(Guangtui.Request rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount("广推DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(guangtuiProperties.getUrl(), rtbRequest), "invokeDSP", "guangtui");
        } catch (Throwable t) {
            Cat.logMetricForCount("广推_竞价失败");
            if (!(t instanceof SocketTimeoutException || t instanceof ResourceAccessException)) {
                SamplerLog.warn("广推竞价失败", t);
            }
            return null;
        }
    }

    private Guangtui.Response doHttpInvoke(String url, Guangtui.Request rtbRequest) throws IOException {

        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-protobuf");
        headers.add("Connection", "keep-alive");
        HttpEntity<byte[]> requestEntity = new HttpEntity<>(rtbRequest.toByteArray(), headers);
        ResponseEntity<org.springframework.core.io.Resource> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class);
        org.springframework.core.io.Resource resource = resEntity.getBody();
        if (resource == null) {
            return null;
        }
        Guangtui.Response body = Guangtui.Response.parseFrom(resource.getInputStream());
        if (body.getCode() == 0) {
            Cat.logMetricForCount("广推DSP返回");
            return body;
        } else {
            //protobuf 对象转json
            SamplerLog.info("广推dsp 返回 {}", JsonFormat.printer().omittingInsignificantWhitespace().print(body));
            return null;
        }
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            byte[] keyBytes = guangtuiProperties.getSecret().getBytes(StandardCharsets.UTF_8);
            SecretKeySpec skeySpec = new SecretKeySpec(keyBytes, "AES");
            // 以密钥的前 16 位作为 IV 向量
            byte[] iv = new byte[16];
            System.arraycopy(keyBytes, 0, iv, 0, 16);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(Cipher.ENCRYPT_MODE, skeySpec, ivParameterSpec);
            byte[] encrypted = cipher.doFinal(price.toString().getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64String(encrypted);
        } catch (Exception e) {
            log.warn("GunagtuiDspInvoker 价格解密失败", e);
        }

        return null;
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_22.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_22;
    }

    @Override
    public Guangtui.Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return guangtuiRequestConverter.reqConvert(adxCommonBidRequest, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(Guangtui.Response rtbResponse) throws DspException {
        try {
            return guangtuiResponseConverter.respConvert(rtbResponse);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected String replaceUrl(String price, String url) {
        String defaultCoordinate = "-999";
        if (url.contains("_PRICE_") && price != null) {
            url = url.replace("_PRICE_", price);
        }
        // 广告位尺寸
        if (url.contains("_WIDTH_")) {
            url = url.replace("_WIDTH_", "500");
        }
        if (url.contains("_HEIGHT_")) {
            url = url.replace("_HEIGHT_", "500");
        }

        // 点击坐标（相对于广告位）
        if (url.contains("_SBZMX_")) {
            url = url.replace("_SBZMX_", defaultCoordinate);
        }
        if (url.contains("_SBZMY_")) {
            url = url.replace("_SBZMY_", defaultCoordinate);
        }
        if (url.contains("_SBZCX_")) {
            url = url.replace("_SBZCX_", defaultCoordinate);
        }
        if (url.contains("_SBZCY_")) {
            url = url.replace("_SBZCY_", defaultCoordinate);
        }

        // 点击坐标（相对于屏幕）
        if (url.contains("_ABZMX_")) {
            url = url.replace("_ABZMX_", defaultCoordinate);
        }
        if (url.contains("_ABZMY_")) {
            url = url.replace("_ABZMY_", defaultCoordinate);
        }
        if (url.contains("_ABZCX_")) {
            url = url.replace("_ABZCX_", defaultCoordinate);
        }
        if (url.contains("_ABZCY_")) {
            url = url.replace("_ABZCY_", defaultCoordinate);
        }

        // Deeplink唤醒标识
        if (url.contains("_DPLINK_")) {
            url = url.replace("_DPLINK_", "1");
        }

        // 点击ID
        /*if (url.contains("_CLICK_ID_") && params.getClickId() != null) {
            url = url.replace("_CLICK_ID_", params.getClickId());
        }*/

        // 时间戳
        if (url.contains("_ORIGINTIME_")) {
            url = url.replace("_ORIGINTIME_", String.valueOf(System.currentTimeMillis()));
        }
        if (url.contains("_ORIGIN_TIME_S_")) {
            long unixTimestamp = System.currentTimeMillis() / 1000;
            url = url.replace("_ORIGIN_TIME_S_", String.valueOf(unixTimestamp));
        }
        return url;
    }
}
