/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.AdPosition;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Request;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdMobileRequestConvert {
    private static final Logger log = LoggerFactory.getLogger(AdMobileRequestConvert.class);
    @Autowired
    private AppReplace appReplace;

    public Request convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Request request = new Request();
        App app = this.convertApp(adxCommonBidRequest, dspInfo);
        if (app == null) {
            return null;
        }
        request.setApp(app);
        AdPosition adPosition = this.convertAdPosition(adxCommonBidRequest, dspInfo);
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        int bidFloor = Double.valueOf(commonImp.getFloorPrice() * (dspInfo.getMinRoi() / 100.0)).intValue() + 1;
        request.setBidFloor(bidFloor);
        request.setAdPosition(adPosition);
        Device device = this.convertDevice(adxCommonBidRequest, dspInfo);
        if (device == null) {
            return null;
        }
        request.setDevice(device);
        Integer httpProtocol = adxCommonBidRequest.getHttpProtocol();
        request.setHttpsRequired(false);
        if (Objects.equals(httpProtocol, 1)) {
            request.setHttpsRequired(true);
        }
        return request;
    }

    private Device convertDevice(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        if (commonDevice == null) {
            return null;
        }
        Device device = new Device();
        String os = commonDevice.getOs();
        device.setOs(1);
        if (StringUtils.isNotBlank((CharSequence)os) && "1".equals(commonDevice.getOs())) {
            device.setOs(2);
        }
        device.setIp(commonDevice.getIp());
        device.setUserAgent(commonDevice.getUa());
        device.setOsVersion(commonDevice.getOsVersion());
        device.setVendor(commonDevice.getMake());
        device.setMac(commonDevice.getMac());
        device.setMacMd5(commonDevice.getMacMd5());
        device.setOaid(commonDevice.getOaId());
        device.setMd5Oaid(commonDevice.getOaIdMd5());
        device.setImei(commonDevice.getImei());
        device.setMd5Imei(commonDevice.getImeiMd5());
        device.setBatteryStatus("UNKNOWN");
        List<Caid> caids = commonDevice.getCaids();
        if (CollectionUtils.isNotEmpty(caids)) {
            Caid caid = caids.get(0);
            device.setCaid(caid.getId());
            device.setCaidVer(caid.getVersion());
        }
        device.setIdfa(commonDevice.getIdFa());
        device.setMd5Idfa(commonDevice.getIdFaMd5());
        device.setModelNo(commonDevice.getModel());
        device.setOsBootMark(commonDevice.getBootTime());
        device.setOsUpdateMark(commonDevice.getUpdateTime());
        device.setDeviceBirthTime(commonDevice.getBirthTime());
        device.setPaId(commonDevice.getPaid());
        return device;
    }

    private AdPosition convertAdPosition(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        AdPosition adPosition = new AdPosition();
        adPosition.setAdPositionId(dspInfo.getDspTagId());
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        CommonSizeInfo sizeInfo = commonImp.getFilteringSize().get(0);
        adPosition.setAdWidth(sizeInfo.getWidth());
        adPosition.setAdHeight(sizeInfo.getHeight());
        return adPosition;
    }

    private App convertApp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        if (appInfo == null) {
            return null;
        }
        App app = new App();
        app.setAppId(1001888L);
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            String bundle = replaceApp.getBundle();
            app.setPackageName(bundle);
        } else {
            app.setPackageName(appInfo.getBundle());
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getVersion())) {
            app.setAppVersion(appInfo.getVersion());
        } else {
            app.setAppVersion("1.0");
        }
        return app;
    }
}

