/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.adx.center.api.dto.IdeaPriceStrategyDTO;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.BidStatService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculatorCpmService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public abstract class DspFacadeInterface {
    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    private CalculatorCpmService calculatorCpmService;
    @Autowired
    private BidStatService bidStatService;

    abstract AdxCommonBidResponse doInvoke(AdxCommonBidRequest var1, List<DspInfo> var2) throws ExecutionException, InterruptedException, TimeoutException;

    protected AdxCommonBidResponse comparePrice(List<AdxCommonBidResponse> responseList) {
        if (Objects.isNull(responseList) || responseList.isEmpty()) {
            return null;
        }
        double maxPrice = 0.0;
        AdxCommonBidResponse maxPriceResponse = null;
        for (AdxCommonBidResponse adxCommonBidResponse : responseList) {
            CommonSeatBid commonSeatBid = adxCommonBidResponse.getCommonSeatBidList().get(0);
            ResourceIdeaDto resourceIdeaDto = this.bidStatService.getResourceIdeaByCache(String.valueOf(adxCommonBidResponse.getIdeaId()));
            if (resourceIdeaDto == null) continue;
            Integer ideaPriceType = resourceIdeaDto.getPriceType();
            Integer chargeType = resourceIdeaDto.getChargeType();
            Integer priceMode = resourceIdeaDto.getPriceMode();
            if (chargeType == 0 && priceMode == 0) {
                if (ideaPriceType == 0) {
                    commonSeatBid.setPrice(resourceIdeaDto.getIdeaPriceStrategyDTO().getExpectPrice() * 100.0);
                }
                if (ideaPriceType == 1) {
                    AdxCommonBidRequest commonBidRequest = commonSeatBid.getCommonBidRequest();
                    List<CommonImp> impList = commonBidRequest.getImpList();
                    double floorPrice = impList.get(0).getFloorPrice();
                    commonSeatBid.setPrice(floorPrice + resourceIdeaDto.getIdeaPriceStrategyDTO().getExpectPrice() * 100.0);
                }
            }
            if (chargeType == 0) {
                commonSeatBid.setCompareCpm(commonSeatBid.getPrice());
            }
            if (ideaPriceType == 2 && priceMode == 1 && chargeType == 4) {
                double compareCpm = this.calculatorCpmService.cpc2Cpm(commonSeatBid.getPrice(), adxCommonBidResponse);
                SamplerLog.info((String)"dsp comparePrice cpc2Cpm ideaid {} price is {}", (Object[])new Object[]{adxCommonBidResponse.getIdeaId(), compareCpm});
                commonSeatBid.setCompareCpm(compareCpm);
            }
            if (ideaPriceType == 2 && priceMode == 0 && chargeType == 4) {
                IdeaPriceStrategyDTO ideaPriceStrategyDTO = resourceIdeaDto.getIdeaPriceStrategyDTO();
                Double price = ideaPriceStrategyDTO.getExpectPrice() * 100.0;
                double compareCpm = this.calculatorCpmService.cpc2Cpm(price, adxCommonBidResponse);
                SamplerLog.info((String)"dsp comparePrice cpc2Cpm ideaid {} price is {}", (Object[])new Object[]{adxCommonBidResponse.getIdeaId(), compareCpm});
                commonSeatBid.setPrice(price);
                commonSeatBid.setCompareCpm(compareCpm);
            }
            if (chargeType == 5) {
                double compareCpm = this.calculatorCpmService.calculateOcpc(resourceIdeaDto, adxCommonBidResponse);
                SamplerLog.info((String)"dsp comparePrice ocpc ideaid {} compateCpm is {} cpcPrice is {}", (Object[])new Object[]{adxCommonBidResponse.getIdeaId(), compareCpm, commonSeatBid.getPrice()});
                commonSeatBid.setCompareCpm(compareCpm);
            }
            if (chargeType == 3) {
                double compareCpm = this.calculatorCpmService.calculateOcpm(adxCommonBidResponse);
                SamplerLog.info((String)"dsp comparePrice calculateOcpm ideaid {} price is {}", (Object[])new Object[]{adxCommonBidResponse.getIdeaId(), compareCpm});
                commonSeatBid.setCompareCpm(compareCpm);
                commonSeatBid.setPrice(compareCpm);
            }
            if (ideaPriceType == 3) {
                double compareCpm = this.calculatorCpmService.calculateOcpm(adxCommonBidResponse);
                SamplerLog.info((String)"dsp comparePrice calculateOcpm ideaid {} price is {}", (Object[])new Object[]{adxCommonBidResponse.getIdeaId(), compareCpm});
                commonSeatBid.setCompareCpm(compareCpm);
                IdeaPriceStrategyDTO ideaPriceStrategyDTO = resourceIdeaDto.getIdeaPriceStrategyDTO();
                Double price = ideaPriceStrategyDTO.getExpectPrice() * 100.0;
                commonSeatBid.setPrice(price);
            }
            if (!(commonSeatBid.getCompareCpm() > maxPrice)) continue;
            maxPrice = commonSeatBid.getCompareCpm();
            maxPriceResponse = adxCommonBidResponse;
        }
        return maxPriceResponse;
    }

    public abstract String priceEncryption(BigDecimal var1, Integer var2);

    public abstract String replaceUrl(String var1, String var2, Integer var3);

    public abstract void doWinCallBack(String var1, Integer var2);

    public abstract void doClickCallBack(String var1, Integer var2);

    public abstract void doExposureCallBack(String var1, Integer var2);
}

