/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.converter;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.req.AdAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.req.AdDeviceInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.req.AdGpsInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.req.AdPosInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.req.AdRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.req.AdUserInfo;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HuichuanRequestConverter {
    private static final Logger log = LoggerFactory.getLogger(HuichuanRequestConverter.class);
    @Autowired
    private AppReplace appReplace;

    public AdRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        AdRequest adRequest = new AdRequest();
        adRequest.setRequest_id(adxCommonBidRequest.getRequestId());
        List<AdPosInfo> impList = this.convertImp(adxCommonBidRequest, dspInfo);
        adRequest.setAd_pos_info(impList);
        adRequest.setAd_app_info(this.convertApp(adxCommonBidRequest, dspInfo));
        AdDeviceInfo deviceInfo = this.convertDevice(adxCommonBidRequest);
        adRequest.setAd_device_info(deviceInfo);
        AdGpsInfo adGpsInfo = this.convertGpsInfo(adxCommonBidRequest);
        adRequest.setAd_gps_info(adGpsInfo);
        AdUserInfo adUserInfo = this.convertUserInfo(adxCommonBidRequest);
        adRequest.setAd_user_info(adUserInfo);
        return adRequest;
    }

    private AdAppInfo convertApp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        AdAppInfo adAppInfo = new AdAppInfo();
        CommonDevice device = adxCommonBidRequest.getDevice();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        adAppInfo.setFr(this.convertFr(device.getOs()));
        adAppInfo.setUa(device.getUa());
        if (replaceApp != null) {
            adAppInfo.setPkg_name(replaceApp.getBundle());
            adAppInfo.setPkg_ver(replaceApp.getVersion());
            adAppInfo.setApp_name(replaceApp.getName());
        } else {
            adAppInfo.setPkg_name(appInfo.getBundle());
            adAppInfo.setPkg_ver(appInfo.getVersion());
            adAppInfo.setApp_name(appInfo.getName());
        }
        return adAppInfo;
    }

    private AdDeviceInfo convertDevice(AdxCommonBidRequest adxCommonBidRequest) {
        AdDeviceInfo adDeviceInfo = new AdDeviceInfo();
        CommonDevice device = adxCommonBidRequest.getDevice();
        adDeviceInfo.setClient_ip(device.getIp());
        adDeviceInfo.setImei(device.getImeiMd5());
        adDeviceInfo.setImei_md5(device.getImeiMd5());
        adDeviceInfo.setOaid(device.getOaId());
        adDeviceInfo.setOaid_md5(device.getOaIdMd5());
        adDeviceInfo.setIdfa(device.getIdFa());
        adDeviceInfo.setIdfa_md5(device.getIdFaMd5());
        adDeviceInfo.setCaid(this.getCaidJson(device.getCaids()));
        adDeviceInfo.setDit(device.getBirthTime());
        adDeviceInfo.setSst(device.getBootTime());
        adDeviceInfo.setSut(device.getUpdateTime());
        adDeviceInfo.setOs(this.convertOs(device.getOs()));
        adDeviceInfo.setOsv(device.getOsVersion());
        adDeviceInfo.setSw(0);
        adDeviceInfo.setSh(0);
        adDeviceInfo.setBrand(device.getMake());
        adDeviceInfo.setDevice(device.getModel());
        adDeviceInfo.setAccess(this.convertConnectionType(device.getTuiaConnectionType()));
        adDeviceInfo.setCarrier(this.convertCarrier(device.getCarrier()));
        adDeviceInfo.setMac(device.getMac());
        return adDeviceInfo;
    }

    private AdGpsInfo convertGpsInfo(AdxCommonBidRequest adxCommonBidRequest) {
        AdGpsInfo adGpsInfo = new AdGpsInfo();
        CommonDevice device = adxCommonBidRequest.getDevice();
        CommonGeo geo = device.getGeo();
        if (geo != null) {
            adGpsInfo.setLat(geo.getLat().floatValue());
            adGpsInfo.setLng(geo.getLon().floatValue());
        }
        return adGpsInfo;
    }

    private AdUserInfo convertUserInfo(AdxCommonBidRequest adxCommonBidRequest) {
        AdUserInfo adUserInfo = new AdUserInfo();
        CommonUserInfo commonUserInfo = adxCommonBidRequest.getUserInfo();
        if (commonUserInfo != null) {
            adUserInfo.setGender(commonUserInfo.getGender());
            adUserInfo.setAge(String.valueOf(commonUserInfo.getYob()));
        }
        return adUserInfo;
    }

    private String getCaidJson(List<Caid> caids) {
        if (CollectionUtils.isEmpty(caids)) {
            return null;
        }
        JSONArray caidArr = new JSONArray();
        for (Caid caid : caids) {
            JSONObject caidJson = new JSONObject();
            caidJson.put("version", (Object)caid.getVersion());
            caidJson.put("caid", (Object)caid.getId());
            caidArr.add((Object)caidJson);
        }
        return caidArr.toJSONString();
    }

    private String convertCarrier(String carrier) {
        if (StringUtils.isBlank((CharSequence)carrier)) {
            return "Unknown";
        }
        switch (carrier) {
            case "1": {
                return "ChinaMobile";
            }
            case "2": {
                return "ChinaUnicom";
            }
            case "3": {
                return "ChinaTelecom";
            }
        }
        return "Unknown";
    }

    private String convertConnectionType(Integer connectionType) {
        if (Objects.isNull(connectionType)) {
            return "Unknown";
        }
        switch (connectionType) {
            case 2: {
                return "Wi-Fi";
            }
            case 4: {
                return "2G";
            }
            case 5: {
                return "3G";
            }
            case 6: {
                return "4G";
            }
            case 7: {
                return "5G";
            }
        }
        return "Unknown";
    }

    private String convertOs(String os) {
        if (StringUtils.isBlank((CharSequence)os)) {
            return "unknown";
        }
        switch (os) {
            case "0": {
                return "android";
            }
            case "1": {
                return "ios";
            }
        }
        return "unknown";
    }

    private String convertFr(String os) {
        if (StringUtils.isBlank((CharSequence)os)) {
            return "other";
        }
        switch (os) {
            case "0": {
                return "android";
            }
            case "1": {
                return "iphone";
            }
        }
        return "other";
    }

    private List<AdPosInfo> convertImp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        ArrayList impList = Lists.newArrayList();
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        AdPosInfo adPosInfo = new AdPosInfo();
        adPosInfo.setReq_cnt(1);
        adPosInfo.setMedia_slot_id(commonImp.getExternalAdBlockId());
        adPosInfo.setSlot_id(Integer.parseInt(dspInfo.getDspTagId()));
        adPosInfo.setSlot_type(Integer.parseInt(dspInfo.getDspResId()));
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        adPosInfo.setCpm_floor((int)floorPrice);
        impList.add(adPosInfo);
        return impList;
    }
}

