/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.conver;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.param.MeituanRTB;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.protobuf.ProtocolStringList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MeituanRespConvert {
    public AdxCommonBidResponse convert(MeituanRTB.RtbResponse rtbResponse) {
        if (rtbResponse == null) {
            return null;
        }
        List<MeituanRTB.Bid> bidsList = rtbResponse.getBidsList();
        if (CollectionUtils.isEmpty(bidsList)) {
            return null;
        }
        MeituanRTB.Bid bid = bidsList.get(0);
        AdxCommonBidResponse response = new AdxCommonBidResponse();
        response.setRequestId(rtbResponse.getRequestId());
        response.setDspId(DspEnum.DSP_12.getDspId());
        MeituanRTB.Ad ads = bid.getAds(0);
        CommonSeatBid commonSeatBid = this.bidConvert(ads);
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        commonSeatBidList.add(commonSeatBid);
        response.setCommonSeatBidList(commonSeatBidList);
        return response;
    }

    private CommonSeatBid bidConvert(MeituanRTB.Ad ads) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        MeituanRTB.PriceType priceType = ads.getPriceType();
        if (MeituanRTB.PriceType.CPC_PRICE.equals((Object)priceType)) {
            commonSeatBid.setPrice((double)ads.getBidCpcPrice() / 1000.0);
            commonSeatBid.setPriceType(1);
        } else {
            commonSeatBid.setPrice(Double.valueOf(ads.getBidPrice()));
        }
        ProtocolStringList winNoticeUrlsList = ads.getWinNoticeUrlsList();
        ArrayList<String> winUrls = new ArrayList<String>((Collection<String>)winNoticeUrlsList);
        commonSeatBid.setWinCallbackUrls(winUrls);
        ProtocolStringList impUrlsList = ads.getImpUrlsList();
        ArrayList<String> exposureUrls = new ArrayList<String>((Collection<String>)impUrlsList);
        commonSeatBid.setExposureCallbackUrls(exposureUrls);
        ProtocolStringList clickUrlsList = ads.getClickUrlsList();
        ArrayList<String> clickUrls = new ArrayList<String>((Collection<String>)clickUrlsList);
        commonSeatBid.setClickCallbackUrls(clickUrls);
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        String iconUrl = ads.getIcon();
        String bundle = ads.getPackageName();
        if (StringUtils.isBlank((CharSequence)bundle)) {
            bundle = "com.sankuai.meituan";
        }
        commonCreative.setAppName(ads.getAppName());
        commonCreative.setAppBundle(bundle);
        commonCreative.setIconUrl(iconUrl);
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(iconUrl);
        commonCreative.setCommonIcon(commonIcon);
        MeituanRTB.Size imageSize = ads.getImageSize();
        if (ads.hasVideo()) {
            MeituanRTB.VideoMaterial video = ads.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getVideoUrl());
            String videoUrl = video.getVideoUrl();
            String materialId = this.getMaterialId(videoUrl);
            commonCreative.setMaterialId(materialId);
            commonVideo.setResolutionX(imageSize.getWidth());
            commonVideo.setResolutionY(imageSize.getHeight());
            commonVideo.setDuration(BigDecimal.valueOf(video.getVideoDuration()));
            commonVideo.setSize((int)video.getSize());
            commonVideo.setUnit("Byte");
            commonVideo.setCoverUrl(video.getCoverUrl());
            commonVideo.setCoverWidth(imageSize.getWidth());
            commonVideo.setCoverHeight(imageSize.getHeight());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            ArrayList<CommonImage> commonImages = new ArrayList<CommonImage>();
            for (String url : ads.getImageUrlsList()) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(url);
                String materialId = this.getMaterialId(url);
                commonCreative.setMaterialId(materialId);
                commonImage.setHeight(imageSize.getHeight());
                commonImage.setWidth(imageSize.getWidth());
                commonImages.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImages);
        }
        if (StringUtils.isNotBlank((CharSequence)ads.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(ads.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)ads.getDescription())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(ads.getDescription());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (StringUtils.isNotBlank((CharSequence)ads.getDeeplinkUrl())) {
            commonCreative.setDeepLinkUrl(ads.getDeeplinkUrl());
            context.setDeepLinkUrl(ads.getDeeplinkUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)ads.getUniversalLink())) {
            commonCreative.setULinkUrl(ads.getUniversalLink());
            context.setULinkUrl(ads.getUniversalLink());
        }
        commonCreative.setLandingPageUrl(ads.getTargetUrl());
        commonSeatBid.setCommonCreative(commonCreative);
        return commonSeatBid;
    }

    private String getMaterialId(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        String[] split = url.split("/");
        return split[split.length - 1];
    }
}

