package cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import lombok.Data;

import java.util.List;

@Data
public class CommonSeatBid {

    /**
     * 广告主id
     */
    private String advertiserId;

    /**
     * 出价
     * 单位：分/CPM
     */
    private Double price;

    /**
     * 计算出来的用来比较出价的cpm值
     */
    private double compareCpm;

    /**
     * 出价类型
     * 0-cpm 1-cpc 2-cpa
     */
    private int priceType;

    /**
     * 胜出url
     */
    private List<String> winCallbackUrls;
    /**
     * 曝光url
     */
    private List<String> exposureCallbackUrls;


    /**
     * 点击url
     */
    private List<String> clickCallbackUrls;

    /**
     * 开始下载监控 url 列表
     */
    private List<String> startDownloadUrls;

    /**
     * 下载完成监控 url 列表
     */
    private List<String> finishDownloadUrls;

    /**
     * 开始安装监控 url 列表
     */
    private List<String> startInstallUrls;

    /**
     * 安装完成监控 url 列表
     */
    private List<String> finishInstallUrls;

    /**
     * 打开app通知url列表
     */
    private List<String> appOpenUrls;

    /**
     * 唤醒成功url列表
     */
    private List<String> deeplinkSuccessUrls;

    /**
     * 关闭广告通知url列表
     */
    private List<String> closeAdUrls;


    /**
     * 创意
     */
    private CommonCreative commonCreative;

    /**
     * 竞价过程中生成的参数
     * 比如：adxRid
     */
    private CommonContext commonContext;

    /**
     * 竞价请求公共参数
     * 比如：adxRid
     */
    private AdxCommonBidRequest commonBidRequest;

    /**
     * 广告位类型
     */
    private Integer adSlotType;
}
