/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.resp.HuichuanResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class HuichuanResponseConverter {
    public AdxCommonBidResponse respConvert(HuichuanResponse rtbResponse) {
        if (Objects.isNull(rtbResponse)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_20.getDspId());
        adxCommonBidResponse.setRequestId(rtbResponse.getSid());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(rtbResponse);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(HuichuanResponse rtbResponse) {
        ArrayList commonSeatBidList = Lists.newArrayList();
        for (HuichuanResponse.SlotAd slotAd : rtbResponse.getSlot_ad()) {
            for (HuichuanResponse.Ad ad : slotAd.getAd()) {
                CommonSeatBid commonSeatBid = new CommonSeatBid();
                commonSeatBid.setAdvertiserId("44910");
                HuichuanResponse.AdContent adContent = ad.getAd_content();
                CommonCreative commonCreative = new CommonCreative();
                HuichuanResponse.AdContent content = ad.getAd_content();
                if (content != null) {
                    commonSeatBid.setPriceType(0);
                    commonSeatBid.setPrice((double)adContent.getDsp_bid_price());
                    CommonTitle commonTitle = new CommonTitle();
                    commonTitle.setTitle(content.getTitle());
                    commonCreative.setCommonTitle(commonTitle);
                    commonCreative.setPrivacyPolicyLink(content.getPrivacy());
                    commonCreative.setPermissionLink(content.getPermission());
                    commonCreative.setAppName(content.getApp_name());
                    commonCreative.setAppBundle(content.getPackage_name());
                    commonCreative.setIconUrl(content.getApp_logo());
                    commonCreative.setDeveloper(content.getDeveloper());
                    commonCreative.setDownloadUrl(content.getDownload_url());
                    commonCreative.setAppFeature(content.getFunction_desc());
                    commonCreative.setULinkUrl(adContent.getAdm_fixed_ulk());
                    CommonContext context = new CommonContext();
                    context.setULinkUrl(adContent.getAdm_fixed_ulk());
                    commonSeatBid.setCommonContext(context);
                    if (StringUtils.isNotBlank((CharSequence)content.getV_1_video_aliyun())) {
                        CommonVideo commonVideo = new CommonVideo();
                        commonVideo.setVideoUrl(content.getV_1_video_aliyun());
                        commonVideo.setDuration(new BigDecimal(Integer.parseInt(content.getV_1_video_duration())));
                        commonVideo.setSize(Integer.parseInt(content.getV_1_video_size()));
                        commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
                    }
                    if (StringUtils.isNotBlank((CharSequence)content.getImg_1())) {
                        CommonImage commonImage = new CommonImage();
                        commonImage.setUrl(content.getImg_1());
                        commonImage.setWidth(Integer.parseInt(content.getImg_1_w()));
                        commonImage.setHeight(Integer.parseInt(content.getImg_1_h()));
                        commonCreative.setCommonImageList(Collections.singletonList(commonImage));
                    }
                    if (StringUtils.isNotBlank((CharSequence)content.getLogo_url())) {
                        CommonIcon commonIcon = new CommonIcon();
                        commonIcon.setUrl(content.getLogo_url());
                        commonCreative.setCommonIcon(commonIcon);
                    }
                }
                commonCreative.setLandingPageUrl(CollectionUtils.isEmpty(ad.getTurl()) ? null : ad.getTurl().get(0));
                commonSeatBid.setCommonCreative(commonCreative);
                commonSeatBid.setWinCallbackUrls(Collections.singletonList(ad.getWnurl()));
                commonSeatBid.setExposureCallbackUrls(ad.getVurl());
                commonSeatBid.setClickCallbackUrls(ad.getCurl());
                commonSeatBidList.add(commonSeatBid);
            }
        }
        return commonSeatBidList;
    }
}

