package cn.com.duiba.duiba.base.service.api.duibaboot.oss.template;

import lombok.Setter;
import org.apache.commons.lang.StringUtils;

import java.net.URI;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/7/21 4:02 下午
 */
@Setter
public class PublicBucketOssTemplate extends AbstractOssTemplate{

    @Override
    public String getUrl(String key) {
        if (StringUtils.isBlank(key)){
            return key;
        }
        String host = cdnHost;
        //兼容没有配置的场景
        if (StringUtils.isBlank(host)){
            host = getBucketHost();
        }
        //e.g: https://yun.kjjcrm.com/object/name.html
        if (key.startsWith("http")){
            return key;
        }
        //e.g: //yun.kjjcrm.com/object/name.html
        if (key.startsWith("//")){
           return "https:"+key;
        }
        //e.g: yun.kjjcrm.com/object/name.html
        if (key.startsWith(host)){
            return "https://"+key;
        }
        //e.g: /object/name.html
        if (key.startsWith("/")){
            return "https://"+host+key;
        }
        //e.g: object/name.html
        return "https://"+host+"/"+key;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        URI uri = URI.create(endPoint);
        bucketHost = bucketName+"."+uri.getHost();
        bucketDomain = uri.getScheme()+"://"+bucketHost;
        if (StringUtils.isNotBlank(cdnDomain)){
            URI uri2 = URI.create(cdnDomain);
            cdnHost = uri2.getHost();
            if (Objects.isNull(cdnHost)){
                throw new RuntimeException("非法的oss域名配置:"+cdnDomain);
            }
        }
    }

}
