package cn.com.duiba.duiba.base.service.api.id.generator.configuration;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

/**
 * @author lizhi
 * @date 2024/12/30 13:42
 */
@Getter
public enum TimeLevel {

    /**
     * 发号不进行时间段的重置
     */
    NONE(""),
    /**
     * 按天进行重置
     */
    DAY("yyyy-MM-dd"),
    /**
     * 按月进行重置
     */
    MONTH("yyyy-MM"),
    /**
     * 按年进行重置
     */
    YEAR("yyyy");
    private final SimpleDateFormat format;
    private final String code;

    TimeLevel(String format){
        this.code = format;
        if(StringUtils.isBlank(format)){
            this.format = null;
        }else {
            this.format = new SimpleDateFormat(format);
        }
    }

    public String formatTime(Date time){
        if(Objects.isNull(format)){
            return "";
        }
        synchronized (format) {
            return format.format(time);
        }
    }
}
