package cn.com.duiba.duiba.base.service.api.mybatis.plugins.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2024/9/24 14:31
 */
@Getter
@Setter
@ConfigurationProperties(prefix = QyDbEncryptProperties.QUAN_YI_ENCRYPT_PREFIX)
public class QyDbEncryptProperties {
    
    public static final String QUAN_YI_ENCRYPT_PREFIX = "qy.db.encrypt";
    
    
    /**
     * 数据库表相关配置
     * qy.db.encrypt.tables.${tableName}.columns.${columnName}.encryptor=A
     * qy.db.encrypt.tables.${tableName}.columns.${columnName}.version=1
     * qy.db.encrypt.tables.${tableName}.columns.${columnName}.names=userPhone,idCard
     * 示例
     * qy.db.encrypt.tables.tb_live_agent.columns.phone_num.encryptor=A
     * qy.db.encrypt.tables.tb_live_agent.columns.phone_num.version=1
     * qy.db.encrypt.tables.tb_live_agent.columns.phone_num.names=userPhone,idCard
     */
    private Map<String, DbEncryptTableRule> tables = new LinkedHashMap<>();

    /**
     * 密钥相关配置
     * qy.db.encrypt.secrets.${encryptor+version}=secret
     * 示例
     * qy.db.encrypt.secrets.S1=123456
     * qy.db.encrypt.secrets.S2=123456
     */
    private Map<String, String> secrets = new LinkedHashMap<>();
}
