package cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.impl;


import cn.com.duiba.duiba.base.service.api.mybatis.plugins.bean.DbEncryptionConstant;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.config.DbEncryptColumnRule;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.SqlCommandAdapter;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.SqlCommandHandler;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.jetbrains.annotations.NotNull;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2024/9/24 15:28
 */
@Configuration
@ConditionalOnClass({SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class})
public class InsertSqlHandler extends AbstractSqlCommandHandler implements SqlCommandHandler {
    
    @NotNull
    @Override
    public SqlCommandType sqlCommandType() {
        return SqlCommandType.INSERT;
    }

    @Override
    public String getTableName(String sql) {
        return getTableName(sql, DbEncryptionConstant.LEFT_BRACKET);
    }

    @Override
    protected int getSpecialTbIndex(String sql) {
        return getSpecialTbIndex(sql, LOWER_INTO);
    }

    @Override
    public Map<Integer, DbEncryptColumnRule> getNeedEncryptParamIndexRule(String sql, Map<String, DbEncryptColumnRule> columns) {
        Map<Integer, DbEncryptColumnRule> indexRuleMap = new LinkedHashMap<>();
        if (StringUtils.isBlank(sql)) {
            return indexRuleMap;
        }
        int leftBracketIndex = sql.indexOf(DbEncryptionConstant.LEFT_BRACKET);
        int rightBracketIndex = sql.indexOf(DbEncryptionConstant.RIGHT_BRACKET);
        if (leftBracketIndex < 0 || rightBracketIndex < 0) {
            return indexRuleMap;
        }
        String[] split = sql.substring(leftBracketIndex + DbEncryptionConstant.LEFT_BRACKET.length(), rightBracketIndex).split(DbEncryptionConstant.COMMA);
        Map<Integer, DbEncryptColumnRule> nameIndexRuleMap = new LinkedHashMap<>();
        for (int i = 0; i < split.length; i++) {
            String name = split[i];
            DbEncryptColumnRule rule = columns.get(name.trim());
            if (rule != null) {
                nameIndexRuleMap.put(i, rule);
            }
        }
        if (MapUtils.isEmpty(nameIndexRuleMap)) {
            return indexRuleMap;
        }
        int size = split.length;
        int valueIndex = 0;
        rightBracketIndex = sql.indexOf(DbEncryptionConstant.RIGHT_BRACKET, rightBracketIndex + 1);
        while (rightBracketIndex >= 0) {
            for (Map.Entry<Integer, DbEncryptColumnRule> entry : nameIndexRuleMap.entrySet()) {
                indexRuleMap.put((valueIndex * size) + entry.getKey(), entry.getValue());
            }
            rightBracketIndex = sql.indexOf(DbEncryptionConstant.RIGHT_BRACKET, rightBracketIndex + 1);
            valueIndex++;
        }
        return indexRuleMap;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        SqlCommandAdapter.register(this);
    }
}
