package cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.impl;


import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.SqlCommandAdapter;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.SqlCommandHandler;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.jetbrains.annotations.NotNull;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;

/**
 * @author lizhi
 * @date 2024/9/24 15:28
 */
@Configuration
@ConditionalOnClass({SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class})
public class UpdateSqlHandler extends AbstractSqlCommandHandler implements SqlCommandHandler {
    
    @NotNull
    @Override
    public SqlCommandType sqlCommandType() {
        return SqlCommandType.UPDATE;
    }

    @Override
    public String getTableName(String sql) {
        return getTableName(sql, LOWER_SET);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        SqlCommandAdapter.register(this);
    }

    @Override
    protected int getSpecialTbIndex(String sql) {
        return getSpecialTbIndex(sql, LOWER_UPDATE);
    }
}
