/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.id.generator;

import cn.com.duiba.duiba.base.service.api.id.generator.bean.IdGeneratorKey;
import cn.com.duiba.duiba.base.service.api.id.generator.configuration.IdGeneratorProperties;
import cn.com.duiba.duiba.base.service.api.id.generator.configuration.Scene;
import cn.com.duiba.duiba.base.service.api.id.generator.exception.IdGeneratorException;
import cn.com.duiba.duiba.base.service.api.id.generator.service.IdGeneratorCache;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.scheduling.annotation.Scheduled;

public class IdGeneratorClient
implements SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(IdGeneratorClient.class);
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    @Resource
    private IdGeneratorProperties idGeneratorProperties;
    private final LoadingCache<IdGeneratorKey, IdGeneratorCache> cache = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<IdGeneratorKey, IdGeneratorCache>(){

        public IdGeneratorCache load(@NonNull IdGeneratorKey key) {
            IdGeneratorCache idGeneratorCache = new IdGeneratorCache(IdGeneratorClient.this.redisAtomicClient, IdGeneratorClient.this.idGeneratorProperties);
            idGeneratorCache.setScene(IdGeneratorClient.this.idGeneratorProperties.getScenes().get(key.getSceneKey()));
            idGeneratorCache.setKey(key);
            idGeneratorCache.init();
            return idGeneratorCache;
        }
    });

    public Long idGenerator(String sceneKey) {
        return this.generator(sceneKey, new Date());
    }

    private Long generator(String sceneKey, Date time) {
        Scene scene = this.idGeneratorProperties.getScenes().get(sceneKey);
        IdGeneratorCache idGeneratorCache = this.getCache(sceneKey, scene, time);
        return Objects.requireNonNull(idGeneratorCache).get();
    }

    private IdGeneratorCache getCache(String sceneKey, Scene scene, Date time) {
        if (Objects.isNull(scene)) {
            throw new IdGeneratorException("\u53d1\u53f7\u573a\u666f[" + sceneKey + "]\u672a\u914d\u7f6e");
        }
        String formatTime = scene.getTimeLevel().formatTime(time);
        IdGeneratorKey key = new IdGeneratorKey();
        key.setSceneKey(sceneKey);
        key.setTime(formatTime);
        return (IdGeneratorCache)this.cache.get((Object)key);
    }

    @Scheduled(cron="0 0 1/1 * * ?")
    public void scanCache() {
        HashSet keys = Sets.newHashSet();
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            IdGeneratorCache idGeneratorCache = (IdGeneratorCache)entry.getValue();
            if (!idGeneratorCache.isInvalidate()) continue;
            keys.add(entry.getKey());
        }
        for (IdGeneratorKey key : keys) {
            this.cache.invalidate((Object)key);
        }
    }

    public void afterSingletonsInstantiated() {
        try {
            Map<String, Scene> scenes = this.idGeneratorProperties.getScenes();
            if (scenes == null || scenes.isEmpty()) {
                return;
            }
            for (Map.Entry<String, Scene> entry : this.idGeneratorProperties.getScenes().entrySet()) {
                this.getCache(entry.getKey(), entry.getValue(), new Date());
                log.info("IdGenerator, init key={}", (Object)entry.getKey());
            }
        }
        catch (Exception e) {
            log.warn("IdGenerator, init error, \u4e0d\u5f71\u54cd\u4f7f\u7528, \u4ec5\u7b2c\u4e00\u6b21\u83b7\u53d6\u5355\u53f7\u7684\u65f6\u5019\u65e0\u6cd5\u4ece\u672c\u5730\u7f13\u5b58\u83b7\u53d6\uff0c\u4f1a\u4eceredis\u53d6\u800c\u5df2, cache.size={}, ", (Object)this.cache.asMap().size(), (Object)e);
        }
    }
}

