/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.mybatis.plugins;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.bean.PropertyValueBean;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.config.DbEncryptColumnRule;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.config.DbEncryptTableRule;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.SqlCommandAdapter;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt.EncryptionDecryptionAdapter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class}), @Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DbEncryptionPlugin
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DbEncryptionPlugin.class);
    private final Map<String, DbEncryptTableRule> tables = new LinkedHashMap<String, DbEncryptTableRule>();
    private final Map<String, String> secretMap = new LinkedHashMap<String, String>();
    private static final String FRCH = "__frch_";
    private static final String LOWER_SELECT = "select";
    private static final String LOWER_FROM = "from";

    /*
     * Exception decompiling
     */
    public Object intercept(Invocation invocation) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MappedStatement getMappedStatement(Object target, Object arg) throws BizException {
        if (!(target instanceof Executor)) {
            throw new BizException("target\u975eExecutor");
        }
        if (!(arg instanceof MappedStatement)) {
            throw new BizException("\u7b2c\u4e00\u53c2\u6570\u975eMappedStatement");
        }
        return (MappedStatement)arg;
    }

    private String getClassAndMethod(MappedStatement mappedStatement) {
        String[] strArr = mappedStatement.getId().split("\\.");
        return strArr[strArr.length - 2] + "." + strArr[strArr.length - 1];
    }

    private SqlCommandType getSqlCommandType(MappedStatement mappedStatement, String classAndMethod) throws BizException {
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (sqlCommandType == null) {
            throw new BizException(classAndMethod + " sqlCommandType\u4e3anull");
        }
        return sqlCommandType;
    }

    private BoundSql getBoundSql(MappedStatement mappedStatement, Object[] args, String classAndMethod) throws BizException {
        BoundSql boundSql = mappedStatement.getBoundSql(args[1]);
        if (boundSql == null) {
            throw new BizException(classAndMethod + " boundSql\u4e3anull");
        }
        return boundSql;
    }

    private DbEncryptTableRule getDbEncryptTableRule(SqlCommandType sqlCommandType, BoundSql boundSql, String classAndMethod) throws BizException {
        String tableName = SqlCommandAdapter.getTableName(sqlCommandType, boundSql.getSql());
        if (tableName == null || tableName.isEmpty()) {
            throw new BizException(classAndMethod + " \u83b7\u53d6tableName\u5931\u8d25");
        }
        return this.tables.get(tableName);
    }

    private Map<String, PropertyValueBean> getNeedEncryptParamsRule(MappedStatement mappedStatement, SqlCommandType sqlCommandType, BoundSql boundSql, Map<String, DbEncryptColumnRule> columns, String classAndMethod) throws BizException {
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings == null || parameterMappings.isEmpty()) {
            log.warn("DbEncryptionPlugin, parameterMappings is null or empty, sql={}, classAndMethod={}", (Object)boundSql.getSql(), (Object)classAndMethod);
            return Collections.emptyMap();
        }
        Map<Integer, DbEncryptColumnRule> paramIndexRuleMap = SqlCommandAdapter.getNeedEncryptParamIndexRule(sqlCommandType, boundSql.getSql(), columns);
        if (paramIndexRuleMap.isEmpty()) {
            return Collections.emptyMap();
        }
        MetaObject metaObject = null;
        HashMap<String, PropertyValueBean> paramRuleMap = new HashMap<String, PropertyValueBean>();
        for (Map.Entry<Integer, DbEncryptColumnRule> entry : paramIndexRuleMap.entrySet()) {
            String property = this.getProperty(entry.getKey(), parameterMappings, boundSql);
            if (property == null) continue;
            metaObject = this.put(mappedStatement, classAndMethod, paramRuleMap, property, entry.getValue(), metaObject, boundSql);
        }
        return paramRuleMap;
    }

    private MetaObject put(MappedStatement mappedStatement, String classAndMethod, Map<String, PropertyValueBean> paramRuleMap, String property, DbEncryptColumnRule rule, MetaObject metaObject, BoundSql boundSql) throws BizException {
        Object parameterObject = boundSql.getParameterObject();
        if (!property.startsWith(FRCH)) {
            this.putNotFrch(paramRuleMap, property, rule);
            return metaObject;
        }
        int separatorIndex = property.indexOf(".");
        if (separatorIndex >= 0) {
            this.putFrchObj(paramRuleMap, property, rule, separatorIndex);
            return metaObject;
        }
        if (metaObject == null) {
            metaObject = this.getMetaObject(mappedStatement, classAndMethod, parameterObject);
        }
        this.putFrchNotObj(paramRuleMap, property, rule, metaObject, boundSql);
        return metaObject;
    }

    private Object encrypt(Map<String, PropertyValueBean> paramsRuleMap, Object parameterObject, String classAndMethod) throws BizException {
        if (parameterObject == null || MapUtils.isEmpty(paramsRuleMap)) {
            return parameterObject;
        }
        if (parameterObject instanceof String) {
            return this.encryptString((String)parameterObject, paramsRuleMap, classAndMethod);
        }
        Class<?> clazz = parameterObject.getClass();
        if (this.isPrimitive(clazz)) {
            throw new BizException(classAndMethod + " \u9700\u8981\u52a0\u5bc6\uff0c\u4f46\u5165\u53c2\u4e3a\u975e\u5b57\u7b26\u4e32\u7c7b\u578b\u7684\u57fa\u672c\u7c7b\u578b");
        }
        if (parameterObject instanceof Map) {
            return this.encryptMap(this.toMap(parameterObject), paramsRuleMap, classAndMethod);
        }
        if (parameterObject instanceof Collection) {
            return this.encryptCollection(this.toCollection(parameterObject), paramsRuleMap, classAndMethod);
        }
        return this.encryptObject(parameterObject, paramsRuleMap);
    }

    private String encryptString(String parameterObject, Map<String, PropertyValueBean> paramsRuleMap, String classAndMethod) throws BizException {
        if (paramsRuleMap.size() != 1) {
            throw new BizException(classAndMethod + " \u9700\u8981\u52a0\u5bc6\uff0c\u5165\u53c2\u4e3aString\uff0c\u4f46\u662fparamsRuleMap.size!=1");
        }
        PropertyValueBean bean = paramsRuleMap.values().stream().filter(Objects::nonNull).findFirst().orElse(null);
        if (bean == null) {
            return parameterObject;
        }
        DbEncryptColumnRule rule = bean.getRule();
        return EncryptionDecryptionAdapter.encryptString(parameterObject, rule, this.secretMap);
    }

    private Map<Object, Object> encryptMap(Map<Object, Object> parameterObject, Map<String, PropertyValueBean> paramsRuleMap, String classAndMethod) throws BizException {
        if (MapUtils.isEmpty(parameterObject)) {
            return parameterObject;
        }
        LinkedHashMap<Object, Object> newValueMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : parameterObject.entrySet()) {
            this.encryptMap(entry, newValueMap, paramsRuleMap, classAndMethod);
        }
        if (MapUtils.isNotEmpty(newValueMap)) {
            parameterObject.putAll(newValueMap);
        }
        return parameterObject;
    }

    private void encryptMap(Map.Entry<Object, Object> entry, Map<Object, Object> newValueMap, Map<String, PropertyValueBean> paramsRuleMap, String classAndMethod) throws BizException {
        Object key = entry.getKey();
        Object value = entry.getValue();
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            newValueMap.put(key, this.encryptMapCollection(key, this.toCollection(value), paramsRuleMap, classAndMethod));
            return;
        }
        if (value instanceof Map) {
            return;
        }
        if (this.isPrimitive(value.getClass())) {
            return;
        }
        PropertyValueBean bean = paramsRuleMap.get(key.toString());
        if (bean == null) {
            return;
        }
        Pair<Boolean, Object> pair = this.encryptOrDecryptJson(value, bean.getRule(), true);
        if (BooleanUtils.isNotTrue((Boolean)((Boolean)pair.getLeft()))) {
            return;
        }
        newValueMap.put(key, pair.getValue());
    }

    private Object encryptMapCollection(Object key, Collection<Object> collection, Map<String, PropertyValueBean> paramsRuleMap, String classAndMethod) throws BizException {
        if (CollectionUtils.isEmpty(collection)) {
            return collection;
        }
        PropertyValueBean bean = paramsRuleMap.get(key.toString());
        if (bean != null) {
            return this.encryptOrDecryptCollectionJson(collection, bean.getRule(), true, true);
        }
        Object value = collection.stream().filter(Objects::nonNull).findFirst().orElse(null);
        if (value == null) {
            return collection;
        }
        if (value instanceof String) {
            DbEncryptColumnRule rule = this.getCollectionStringRule(collection, paramsRuleMap, classAndMethod);
            return this.encryptOrDecryptCollectionString(collection, rule, true, true);
        }
        return this.encryptCollectionObject(collection, paramsRuleMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object decrypt(Object proceed, MappedStatement mappedStatement, BoundSql boundSql, DbEncryptTableRule columns, String classAndMethod) throws BizException {
        List resultMaps = mappedStatement.getResultMaps();
        if (CollectionUtils.isEmpty((Collection)resultMaps)) {
            return proceed;
        }
        long start = System.currentTimeMillis();
        try {
            List<String> columnList = this.getResultColumns(boundSql.getSql());
            Map<String, DbEncryptColumnRule> propertyRuleMap = this.getPropertyRuleMap(resultMaps, columns.getColumns(), columnList);
            if (MapUtils.isEmpty(propertyRuleMap)) {
                Object object = proceed;
                return object;
            }
            Object object = this.decrypt(proceed, propertyRuleMap, classAndMethod);
            return object;
        }
        finally {
            log.info("DbEncryptionPlugin, decrypt, boundSql={}, cost={}ms", (Object)boundSql.getSql(), (Object)(System.currentTimeMillis() - start));
        }
    }

    private Object decrypt(Object result, Map<String, DbEncryptColumnRule> propertyRuleMap, String classAndMethod) throws BizException {
        if (result instanceof String && propertyRuleMap.size() != 1) {
            throw new BizException(classAndMethod + " \u67e5\u8be2\u4e00\u4e2a\u5b57\u6bb5\uff0c\u4f46\u662f\u6709\u591a\u4e2a\u5b57\u6bb5\u8981\u89e3\u5bc6");
        }
        if (result instanceof String) {
            DbEncryptColumnRule firstRule = this.getFirstRule(propertyRuleMap);
            return this.encryptOrDecryptJsonString((String)result, firstRule, false);
        }
        if (result instanceof Collection) {
            return this.decryptCollection(this.toCollection(result), propertyRuleMap, classAndMethod);
        }
        if (result instanceof Map) {
            return result;
        }
        return this.decryptObject(result, propertyRuleMap);
    }

    private Collection<Object> decryptCollection(Collection<Object> collection, Map<String, DbEncryptColumnRule> propertyRuleMap, String classAndMethod) throws BizException {
        if (CollectionUtils.isEmpty(collection)) {
            return collection;
        }
        Object value = collection.stream().filter(Objects::nonNull).findFirst().orElse(null);
        if (value == null) {
            return collection;
        }
        if (this.isPrimitive(value.getClass())) {
            return collection;
        }
        if (value instanceof String && propertyRuleMap.size() != 1) {
            throw new BizException(classAndMethod + " \u67e5\u8be2\u4e00\u4e2a\u5b57\u6bb5\u96c6\u5408\uff0c\u4f46\u662f\u6709\u591a\u4e2a\u5b57\u6bb5\u8981\u89e3\u5bc6");
        }
        if (value instanceof String) {
            DbEncryptColumnRule firstRule = this.getFirstRule(propertyRuleMap);
            return this.encryptOrDecryptCollectionString(collection, firstRule, false, true);
        }
        if (value instanceof List) {
            return collection;
        }
        if (value instanceof Map) {
            return collection;
        }
        for (Object v : collection) {
            this.decryptObject(v, propertyRuleMap);
        }
        return collection;
    }

    private DbEncryptColumnRule getFirstRule(Map<String, DbEncryptColumnRule> propertyRuleMap) {
        return propertyRuleMap.values().stream().filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static List<Field> getNotStaticField(Object obj) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fieldList.add(field);
            }
        }
        return fieldList;
    }

    private Object decryptObject(Object result, Map<String, DbEncryptColumnRule> propertyRuleMap) {
        try {
            List<Field> collect = DbEncryptionPlugin.getNotStaticField(result);
            for (Field field : collect) {
                String name = field.getName();
                DbEncryptColumnRule rule = propertyRuleMap.get(name);
                if (rule == null) continue;
                this.encryptOrDecryptObject(rule, field, result, false);
            }
            return result;
        }
        catch (IllegalAccessException e) {
            return result;
        }
    }

    private Map<String, DbEncryptColumnRule> getPropertyRuleMap(List<ResultMap> resultMaps, Map<String, DbEncryptColumnRule> columns, List<String> columnList) {
        HashMap<String, DbEncryptColumnRule> propertyRuleMap = new HashMap<String, DbEncryptColumnRule>();
        for (ResultMap resultMap : resultMaps) {
            List propertyResultMappings = resultMap.getPropertyResultMappings();
            if (CollectionUtils.isNotEmpty((Collection)propertyResultMappings)) {
                this.putPropertyResultMappings(propertyResultMappings, columns, propertyRuleMap);
                continue;
            }
            this.putByColumn(columnList, columns, propertyRuleMap);
        }
        return propertyRuleMap;
    }

    private void putByColumn(List<String> columnList, Map<String, DbEncryptColumnRule> columns, Map<String, DbEncryptColumnRule> propertyRuleMap) {
        if (CollectionUtils.isEmpty(columnList)) {
            return;
        }
        for (String column : columnList) {
            Pair<String, String> pair = this.parseColumn(column);
            DbEncryptColumnRule rule = columns.get(pair.getLeft());
            if (rule == null) continue;
            propertyRuleMap.put((String)pair.getRight(), rule);
        }
    }

    private Pair<String, String> parseColumn(String column) {
        int spaceIndex = column.indexOf(" ");
        String columnName = spaceIndex < 0 ? column : column.substring(0, spaceIndex);
        int lastSpaceIndex = column.lastIndexOf(" ");
        String property = lastSpaceIndex < 0 ? this.toHump(column) : column.substring(lastSpaceIndex + 1);
        return Pair.of((Object)columnName, (Object)property);
    }

    private String toHump(String column) {
        String[] split = column.split("_");
        if (split.length == 1) {
            return split[0];
        }
        StringBuilder property = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String part = split[i];
            if (i == 0) {
                property.append(part);
                continue;
            }
            property.append(part.substring(0, 1).toUpperCase()).append(part.substring(1).toLowerCase());
        }
        return property.toString();
    }

    private List<String> getResultColumns(String sql) {
        int selectIndex = sql.toLowerCase().indexOf(LOWER_SELECT);
        int fromIndex = sql.toLowerCase().indexOf(LOWER_FROM);
        if (selectIndex < 0 || fromIndex < 0 || selectIndex + LOWER_SELECT.length() >= fromIndex) {
            return Collections.emptyList();
        }
        String[] split = sql.substring(selectIndex + LOWER_SELECT.length(), fromIndex).split(",");
        return Arrays.stream(split).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private void putPropertyResultMappings(List<ResultMapping> propertyResultMappings, Map<String, DbEncryptColumnRule> columns, Map<String, DbEncryptColumnRule> propertyRuleMap) {
        for (ResultMapping resultMapping : propertyResultMappings) {
            String column = resultMapping.getColumn();
            DbEncryptColumnRule rule = columns.get(column);
            if (rule == null) continue;
            propertyRuleMap.put(resultMapping.getProperty(), rule);
        }
    }

    private Collection<Object> encryptOrDecryptCollection(Collection<Object> collection, DbEncryptColumnRule rule, boolean isEncrypt) {
        if (CollectionUtils.isEmpty(collection)) {
            return collection;
        }
        Object value = collection.stream().filter(Objects::nonNull).findFirst().orElse(null);
        if (value == null) {
            return collection;
        }
        if (value instanceof String) {
            return this.encryptOrDecryptCollectionString(collection, rule, isEncrypt, false);
        }
        if (this.isPrimitive(value.getClass())) {
            return collection;
        }
        if (value instanceof Collection || value instanceof Map) {
            return collection;
        }
        if (CollectionUtils.isEmpty(rule.getNames())) {
            return collection;
        }
        return this.encryptOrDecryptCollectionJsonObj(this.toCollection(collection), rule, isEncrypt);
    }

    private Collection<Object> encryptCollection(Collection<Object> collection, Map<String, PropertyValueBean> paramsRuleMap, String classAndMethod) throws BizException {
        if (CollectionUtils.isEmpty(collection)) {
            return collection;
        }
        Object value = collection.stream().filter(Objects::nonNull).findFirst().orElse(null);
        if (value == null) {
            return collection;
        }
        if (value instanceof Collection || value instanceof Map) {
            return collection;
        }
        if (this.isPrimitive(value.getClass())) {
            return collection;
        }
        if (value instanceof String) {
            DbEncryptColumnRule rule = this.getCollectionStringRule(collection, paramsRuleMap, classAndMethod);
            return this.encryptOrDecryptCollectionString(collection, rule, true, true);
        }
        return this.encryptCollectionObject(collection, paramsRuleMap);
    }

    private Collection<Object> encryptCollectionObject(Collection<Object> collection, Map<String, PropertyValueBean> paramsRuleMap) {
        for (Object v : collection) {
            this.encryptObject(v, paramsRuleMap);
        }
        return collection;
    }

    private Object encryptObject(Object obj, Map<String, PropertyValueBean> paramsRuleMap) {
        if (obj == null) {
            return null;
        }
        try {
            List<Field> fields = DbEncryptionPlugin.getNotStaticField(obj);
            for (Field field : fields) {
                this.encryptObject(field, obj, paramsRuleMap);
            }
            return obj;
        }
        catch (IllegalAccessException e) {
            return obj;
        }
    }

    private void encryptObject(Field field, Object obj, Map<String, PropertyValueBean> paramsRuleMap) throws IllegalAccessException {
        String name = field.getName();
        PropertyValueBean bean = paramsRuleMap.get(name);
        if (bean == null) {
            return;
        }
        DbEncryptColumnRule rule = bean.getRule();
        this.encryptOrDecryptObject(rule, field, obj, true);
    }

    private void encryptOrDecryptObject(DbEncryptColumnRule rule, Field field, Object obj, boolean isEncrypt) throws IllegalAccessException {
        if (rule == null) {
            return;
        }
        this.fieldSetAccessible(field);
        Object value = field.get(obj);
        Pair<Boolean, Object> pair = this.encryptOrDecryptJson(value, rule, isEncrypt);
        if (BooleanUtils.isNotTrue((Boolean)((Boolean)pair.getLeft()))) {
            return;
        }
        this.fieldSet(obj, field, pair.getRight());
    }

    private Pair<Boolean, Object> encryptOrDecryptJson(Object value, DbEncryptColumnRule rule, boolean isEncrypt) {
        if (value == null) {
            return Pair.of((Object)false, null);
        }
        if (value instanceof String) {
            return Pair.of((Object)true, (Object)this.encryptOrDecryptJsonString((String)value, rule, isEncrypt));
        }
        if (this.isPrimitive(value.getClass()) || value instanceof Map) {
            return Pair.of((Object)false, (Object)value);
        }
        if (value instanceof Collection) {
            return Pair.of((Object)true, this.encryptOrDecryptCollection(this.toCollection(value), rule, isEncrypt));
        }
        if (CollectionUtils.isNotEmpty(rule.getNames())) {
            return Pair.of((Object)true, (Object)this.encryptOrDecryptJsonObj(value, rule, isEncrypt));
        }
        return Pair.of((Object)false, (Object)value);
    }

    private String encryptOrDecryptJsonString(String value, DbEncryptColumnRule rule, boolean isEncrypt) {
        if (rule == null) {
            return value;
        }
        if (CollectionUtils.isEmpty(rule.getNames())) {
            return this.encryptOrDecryptString(isEncrypt, value, rule);
        }
        if (value.startsWith("[")) {
            return this.encryptOrDecryptJsonArray(value, rule, isEncrypt);
        }
        if (value.startsWith("{")) {
            return this.encryptOrDecryptJsonObject(value, rule, isEncrypt);
        }
        return this.encryptOrDecryptString(isEncrypt, value, rule);
    }

    private String encryptOrDecryptJsonArray(String value, DbEncryptColumnRule rule, boolean isEncrypt) {
        JSONArray array = JSON.parseArray((String)value);
        Collection<Object> o = this.encryptOrDecryptCollectionJson((Collection<Object>)array, rule, isEncrypt, false);
        return JSON.toJSONString(o);
    }

    private String encryptOrDecryptJsonObject(String value, DbEncryptColumnRule rule, boolean isEncrypt) {
        JSONObject jsonObject = JSON.parseObject((String)value);
        this.encryptOrDecryptJsonMap(jsonObject, rule, isEncrypt);
        return jsonObject.toJSONString();
    }

    @Nullable
    private Collection<Object> encryptOrDecryptCollectionJson(Collection<Object> value, DbEncryptColumnRule rule, boolean isEncrypt, boolean maybeJson) {
        if (value == null) {
            return null;
        }
        Object first = value.stream().filter(Objects::nonNull).findFirst().orElse(null);
        if (first == null) {
            return value;
        }
        if (first instanceof String) {
            return this.encryptOrDecryptCollectionString(value, rule, isEncrypt, maybeJson);
        }
        if (this.isPrimitive(first.getClass())) {
            return value;
        }
        return this.encryptOrDecryptCollectionJsonObj(value, rule, isEncrypt);
    }

    private void encryptOrDecryptJsonMap(JSONObject jsonObject, DbEncryptColumnRule rule, boolean isEncrypt) {
        if (CollectionUtils.isEmpty(rule.getNames()) || MapUtils.isEmpty((Map)jsonObject)) {
            return;
        }
        for (Map.Entry entry : jsonObject.entrySet()) {
            String name = (String)entry.getKey();
            if (!rule.getNames().contains(name) || entry.getValue() == null) continue;
            jsonObject.put(name, (Object)this.encryptOrDecryptString(isEncrypt, entry.getValue().toString(), rule));
        }
    }

    private Object encryptOrDecryptJsonObj(Object value, DbEncryptColumnRule rule, boolean isEncrypt) {
        if (CollectionUtils.isEmpty(rule.getNames()) || value == null) {
            return value;
        }
        try {
            List<Field> collect = DbEncryptionPlugin.getNotStaticField(value);
            for (Field field : collect) {
                this.encryptJsonObjField(value, field, rule, isEncrypt);
            }
            return value;
        }
        catch (IllegalAccessException e) {
            return value;
        }
    }

    private void encryptJsonObjField(Object value, Field field, DbEncryptColumnRule rule, boolean isEncrypt) throws IllegalAccessException {
        String name = field.getName();
        if (!rule.getNames().contains(name)) {
            return;
        }
        this.fieldSetAccessible(field);
        Object v = field.get(value);
        if (v == null) {
            return;
        }
        if (!(v instanceof String)) {
            return;
        }
        this.fieldSet(value, field, this.encryptOrDecryptString(isEncrypt, (String)v, rule));
    }

    private String encryptOrDecryptString(boolean isEncrypt, String v, DbEncryptColumnRule rule) {
        if (isEncrypt) {
            return EncryptionDecryptionAdapter.encryptString(v, rule, this.secretMap);
        }
        return EncryptionDecryptionAdapter.decryptString(v, this.secretMap);
    }

    private DbEncryptColumnRule getCollectionStringRule(Collection<Object> collection, Map<String, PropertyValueBean> paramsRuleMap, String classAndMethod) throws BizException {
        List beanList = paramsRuleMap.values().stream().filter(bean -> {
            if (!bean.isFrch() || bean.isFrchObj()) {
                return false;
            }
            return this.isSameValueCollection(collection, bean.getValueMap());
        }).collect(Collectors.toList());
        if (beanList.isEmpty()) {
            return null;
        }
        if (beanList.size() != 1) {
            throw new BizException(classAndMethod + " \u5bf9\u8c61\u5165\u53c2\uff0c\u6709\u591a\u4e2a\u96c6\u5408\u503c\u76f8\u540c");
        }
        PropertyValueBean bean2 = (PropertyValueBean)beanList.get(0);
        return bean2.getRule();
    }

    private Collection<Object> encryptOrDecryptCollectionString(Collection<Object> collection, DbEncryptColumnRule rule, boolean isEncrypt, boolean maybeJson) {
        if (rule == null) {
            return collection;
        }
        Stream<String> stream = collection.stream().map(v -> maybeJson ? this.encryptOrDecryptJsonString((String)v, rule, isEncrypt) : this.encryptOrDecryptString(isEncrypt, (String)v, rule));
        if (collection instanceof Set) {
            return stream.collect(Collectors.toSet());
        }
        return stream.collect(Collectors.toList());
    }

    private Collection<Object> encryptOrDecryptCollectionJsonObj(Collection<Object> collection, DbEncryptColumnRule rule, boolean isEncrypt) {
        for (Object v : collection) {
            if (v instanceof JSONObject) {
                this.encryptOrDecryptJsonMap((JSONObject)v, rule, isEncrypt);
                continue;
            }
            this.encryptOrDecryptJsonObj(v, rule, isEncrypt);
        }
        return collection;
    }

    private boolean isSameValueCollection(Collection<Object> collection, Map<Integer, Object> valueMap) {
        if (CollectionUtils.isEmpty(collection) || valueMap == null || valueMap.isEmpty() || collection.size() != valueMap.size()) {
            return false;
        }
        int index = 0;
        for (Object v : collection) {
            Object o;
            if (Objects.equals(v, o = valueMap.get(index++))) continue;
            return false;
        }
        return true;
    }

    protected boolean isPrimitive(Class<?> parameterType) {
        return parameterType.isPrimitive() || Number.class.isAssignableFrom(parameterType);
    }

    private MetaObject getMetaObject(MappedStatement mappedStatement, String classAndMethod, Object parameterObject) throws BizException {
        Configuration configuration = mappedStatement.getConfiguration();
        if (configuration == null) {
            throw new BizException(classAndMethod + " configuration\u4e3anull");
        }
        return configuration.newMetaObject(parameterObject);
    }

    private String getProperty(Integer index, List<ParameterMapping> parameterMappings, BoundSql boundSql) {
        if (index == null || index < 0 || index >= parameterMappings.size()) {
            log.warn("DbEncryptionPlugin, index error, index={}, sql={}, parameterMappings={}", new Object[]{index, boundSql.getSql(), JSON.toJSONString(parameterMappings)});
            return null;
        }
        ParameterMapping parameterMapping = parameterMappings.get(index);
        if (parameterMapping == null) {
            log.warn("DbEncryptionPlugin, parameterMapping is null, index={}, sql={}, parameterMappings={}", new Object[]{index, boundSql.getSql(), JSON.toJSONString(parameterMappings)});
            return null;
        }
        return parameterMapping.getProperty();
    }

    private void putNotFrch(Map<String, PropertyValueBean> paramRuleMap, String property, DbEncryptColumnRule rule) {
        PropertyValueBean bean = new PropertyValueBean();
        bean.setRule(rule);
        paramRuleMap.put(property, bean);
    }

    private void putFrchObj(Map<String, PropertyValueBean> paramRuleMap, String property, DbEncryptColumnRule rule, int separatorIndex) {
        String name = property.substring(separatorIndex + 1);
        PropertyValueBean bean = paramRuleMap.computeIfAbsent(name, k -> this.buildPropertyValueBean(rule, null));
        bean.setFrch(true);
        bean.setFrchObj(true);
    }

    private void putFrchNotObj(Map<String, PropertyValueBean> paramRuleMap, String property, DbEncryptColumnRule rule, MetaObject metaObject, BoundSql boundSql) {
        String[] split = property.replace(FRCH, "").split("_");
        String name = split[0];
        int index = Integer.parseInt(split[1]);
        PropertyValueBean bean = paramRuleMap.computeIfAbsent(name, k -> this.buildPropertyValueBean(rule, new HashMap<Integer, Object>()));
        bean.setFrch(true);
        bean.setFrchObj(false);
        Object value = this.getValue(property, metaObject, boundSql);
        if (value != null) {
            bean.getValueMap().put(index, value);
        }
    }

    private Object getValue(String property, MetaObject metaObject, BoundSql boundSql) {
        if (metaObject.hasGetter(property)) {
            return metaObject.getValue(property);
        }
        if (boundSql.hasAdditionalParameter(property)) {
            return boundSql.getAdditionalParameter(property);
        }
        return null;
    }

    private PropertyValueBean buildPropertyValueBean(DbEncryptColumnRule rule, Map<Integer, Object> valueMap) {
        PropertyValueBean bean = new PropertyValueBean();
        bean.setRule(rule);
        bean.setValueMap(valueMap);
        return bean;
    }

    private Map<Object, Object> toMap(Object value) {
        return (Map)value;
    }

    private Collection<Object> toCollection(Object value) {
        return (Collection)value;
    }

    private void fieldSetAccessible(Field field) {
        field.setAccessible(true);
    }

    private void fieldSet(Object obj, Field field, Object value) throws IllegalAccessException {
        field.set(obj, value);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.putTables(properties);
        this.putSecretMap(properties);
    }

    private void putSecretMap(Properties properties) {
        String secretMapJson = properties.getProperty("secretMap");
        if (secretMapJson == null || secretMapJson.isEmpty()) {
            return;
        }
        try {
            Map propertiesSecretMap = (Map)JSON.parseObject((String)secretMapJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            if (propertiesSecretMap == null || propertiesSecretMap.isEmpty()) {
                return;
            }
            this.secretMap.putAll(propertiesSecretMap);
        }
        catch (Exception e) {
            log.error("DbEncryptionPlugin, add secretMap error, e:", (Throwable)e);
        }
    }

    private void putTables(Properties properties) {
        String tablesJson = properties.getProperty("tables");
        if (tablesJson == null || tablesJson.isEmpty()) {
            return;
        }
        try {
            Map propertiesTables = (Map)JSON.parseObject((String)tablesJson, (TypeReference)new TypeReference<Map<String, DbEncryptTableRule>>(){}, (Feature[])new Feature[0]);
            if (propertiesTables == null || propertiesTables.isEmpty()) {
                return;
            }
            this.tables.putAll(propertiesTables);
        }
        catch (Exception e) {
            log.error("DbEncryptionPlugin, add tables error, e:", (Throwable)e);
        }
    }
}

