/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.config.DbEncryptColumnRule;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.encrypt.EncryptionDecryptionHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionDecryptionAdapter {
    private static final Logger log = LoggerFactory.getLogger(EncryptionDecryptionAdapter.class);
    private static final Map<String, EncryptionDecryptionHandler> handlerMap = new HashMap<String, EncryptionDecryptionHandler>();

    private EncryptionDecryptionAdapter() {
    }

    public static void register(EncryptionDecryptionHandler handler) {
        handlerMap.put(handler.encryptorEnum().name(), handler);
    }

    private static EncryptionDecryptionHandler get(String encryptor) {
        EncryptionDecryptionHandler handler = handlerMap.get(encryptor);
        if (handler == null) {
            log.info("EncryptionDecryption, handler is null, encryptor={}", (Object)encryptor);
            return null;
        }
        return handler;
    }

    public static String encryptString(String value, DbEncryptColumnRule rule, Map<String, String> secretMap) {
        if (StringUtils.isBlank((CharSequence)value) || rule == null || MapUtils.isEmpty(secretMap)) {
            return value;
        }
        if (BooleanUtils.isNotTrue((Boolean)rule.getStart())) {
            return value;
        }
        EncryptionDecryptionHandler handler = EncryptionDecryptionAdapter.get(rule.getEncryptor());
        if (handler == null) {
            return value;
        }
        try {
            Pair<String, Integer> pair = EncryptionDecryptionAdapter.parseEncryptorVersion(value);
            if (pair.getLeft() != null && pair.getRight() != null && EncryptionDecryptionAdapter.get((String)pair.getLeft()) != null) {
                return value;
            }
            String secretKey = EncryptionDecryptionAdapter.getSecretKey(rule.getEncryptor(), rule.getVersion());
            String secret = secretMap.get(secretKey);
            if (StringUtils.isBlank((CharSequence)secret)) {
                log.warn("EncryptionDecryption, encrypt secret is blank, encryptor={}, version={}", (Object)rule.getEncryptor(), (Object)rule.getVersion());
                return value;
            }
            String encrypt = handler.encrypt(value, secret);
            if (StringUtils.isBlank((CharSequence)encrypt)) {
                return value;
            }
            return secretKey + "_" + encrypt;
        }
        catch (Exception e) {
            log.error("EncryptionDecryption, encrypt error, encryptor={}, version={}", (Object)rule.getEncryptor(), (Object)rule.getVersion());
            return value;
        }
    }

    private static Pair<String, Integer> parseEncryptorVersion(String value) {
        try {
            int index = value.indexOf("_");
            if (index <= 0) {
                return Pair.of(null, null);
            }
            String encryptor = value.substring(0, 1);
            Integer version = Integer.parseInt(value.substring(1, index));
            return Pair.of((Object)encryptor, (Object)version);
        }
        catch (Exception e) {
            return Pair.of(null, null);
        }
    }

    public static String decryptString(String value, Map<String, String> secretMap) {
        if (StringUtils.isBlank((CharSequence)value) || MapUtils.isEmpty(secretMap)) {
            return value;
        }
        Pair<String, Integer> pair = EncryptionDecryptionAdapter.parseEncryptorVersion(value);
        if (StringUtils.isBlank((CharSequence)((CharSequence)pair.getLeft())) || pair.getRight() == null) {
            return value;
        }
        EncryptionDecryptionHandler handler = EncryptionDecryptionAdapter.get((String)pair.getLeft());
        if (handler == null) {
            return value;
        }
        try {
            String secretKey = EncryptionDecryptionAdapter.getSecretKey((String)pair.getLeft(), (Integer)pair.getRight());
            String secret = secretMap.get(secretKey);
            if (StringUtils.isBlank((CharSequence)secret)) {
                log.warn("EncryptionDecryption, decrypt secret is blank, encryptor={}, version={}", pair.getLeft(), pair.getRight());
                return value;
            }
            String decrypt = handler.decrypt(value.substring((secretKey + "_").length()), secret);
            if (StringUtils.isBlank((CharSequence)decrypt)) {
                return value;
            }
            return decrypt;
        }
        catch (Exception e) {
            log.error("EncryptionDecryption, decrypt error, encryptor={}, version={}", pair.getLeft(), pair.getRight());
            return value;
        }
    }

    private static String getSecretKey(String encryptor, Integer version) {
        return encryptor + version;
    }
}

