package cn.com.duiba.live.activity.center.api.enums.fission;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chenhang
 * @date 2021/12/1 8:53 下午
 */
@Getter
@AllArgsConstructor
public enum LuckCardStatusEnum {
    LUCK_CARD_STATUS_NO(0, "没有抽幸运卡"),
    LUCK_CARD_STATUS_YES(1, "抽过幸运卡");


    private final Integer status;
    private final String desc;

    private static  final Map<Integer, LuckCardStatusEnum> ENUM_MAP;

    static {
        ENUM_MAP = Arrays.stream(LuckCardStatusEnum.values()).collect(Collectors.toMap(LuckCardStatusEnum::getStatus, Function.identity()));
    }

    public static LuckCardStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

}
