package cn.com.duiba.live.activity.center.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.conf.LinkInfoDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteLinkInfoService {

    /**
     * 保存连接信息
     */
    Long insert(LinkInfoDto linkInfoDto);

    /**
     * 根据外键类型和外键id，进行新增或者替换
     */
    Boolean saveOrUpdateByBelongTypeAndForeign(List<LinkInfoDto> linkInfoDto, Integer belongToType, Long foreignId);


    /**
     * 根据外建类型和外键id查询
     *
     * @param belongToType
     * @param foreignId
     * @return
     * @see cn.com.duiba.live.activity.center.api.enums.conf.BelongToTypeEnum
     */
    List<LinkInfoDto> selectByBelongTypeAndForeign(Integer belongToType, Long foreignId);

    /**
     * 根据外建id查询
     *
     * @param foreignId
     * @return
     */
    List<LinkInfoDto> selectByForeignId(Long foreignId);


}
