package cn.com.duiba.live.activity.center.api.remoteservice.fission.achieve;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.fission.achieve.FissionAchieveConfigDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/8/4 19:18
 */
@AdvancedFeignClient
public interface RemoteFissionAchieveConfigService {

    /**
     * 查询活动下的商品配置
     * @param activityId 活动ID
     * @return 商品配置
     */
    List<FissionAchieveConfigDto> findByActivity(Long activityId);

    /**
     * 根据活动ID获取配置
     * @param activityIds 活动ID
     * @return
     */
    List<FissionAchieveConfigDto> findByActivityIds(List<Long> activityIds);

    /**
     * 扣除阶段一库存
     * @param activityId 活动ID
     * @param goodsId 商品ID
     * @return 消耗结果
     */
    boolean reduceFirstStock(Long activityId, Long goodsId);

    /**
     * 消耗最终档库存
     * @param activityId 活动ID
     * @param goodsId 商品ID
     * @return 消耗结果
     */
    boolean reduceFinalStock(Long activityId, Long goodsId);

    /**
     * 批量新增
     * @param dtoList
     * @return 结果
     */
    boolean batchInsert (List<FissionAchieveConfigDto> dtoList);

    /**
     * 查询一个商品的活动配置
     * @param id 主键
     * @return dto
     */
    FissionAchieveConfigDto findById(Long id);

    /**
     * 修改一条记录
     * @param dto
     * @return 执行结果
     */
    boolean updateById(FissionAchieveConfigDto dto);

    /**
     * 删除一条记录（物理删除）
     * @param id
     * @return 执行结果
     */
    boolean deleteById(Long id);

    /**
     * 删除多条记录（物理删除）
     * @param ids
     * @return 执行结果
     */
    boolean deleteByIds(List<Long> ids);

    /**
     * 删除一个活动下所有的商品配置（物理删除）
     * @param activityId
     * @return 执行结果
     */
    boolean deleteByActivityId(Long activityId);

    /**
     * 批量修改记录
     * @param dtoList
     * @return 执行结果
     */
    boolean batchUpdate(List<FissionAchieveConfigDto> dtoList);

}
