package cn.com.duiba.live.activity.center.api.dto.fission.blindbox;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;
import java.util.Date;

/**
* 盲盒抽奖商品规则
 * @author chenhang
*/
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BlindBoxGoodsRuleDto implements Serializable {

    private static final long serialVersionUID = -8738500391945338287L;
    /**
    * 活动id   tb_fission_activity  id
    */
    private Long activityId;

    /**
    * 盲盒配置id  tb_blind_box_goods  id
    */
    private Long configId;

    /**
     * 盲盒id
     */
    private Long blindBoxId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 商品ID
    */
    private Long goodsId;

    /**
    * 商品等级
    */
    private Integer goodsLevel;

    /**
    * 主键
    */
    private Long id;

    /**
    * 开盲盒人数
    */
    private Integer openNum;

    /**
    * 随机发放数量
    */
    private Integer sendNum;

    /**
    * 状态 0:上架 1:下架 
    */
    private Integer ruleStatus;
}

