package cn.com.duiba.live.activity.center.api.dto.user.point;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhuenhui
 * @date 2022-03-30 11：09
 * @description 用户积分变更流水记录 Dto
 */
@Data
public class UserPointRecordDto implements Serializable {

    private static final long serialVersionUID = -7980392384057230120L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户积分记录Id
     */
    private Long userPointId;

    /**
     * 原积分数
     */
    private Integer oldPoint;

    /**
     * 变更积分数
     */
    private Integer changePoint;

    /**
     * 变更类型
     * {@link cn.com.duiba.live.activity.center.api.enums.user.point.UserPointChangeTypeEnum}
     */
    private Integer changeType;

    /**
     * 积分来源渠道
     * {@link cn.com.duiba.live.activity.center.api.enums.user.point.UserPointChannelEnum}
     */
    private Integer pointChannel;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

}

