package cn.com.duiba.live.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * Created by hong
 * time 2021/11/16.
 */
@AdvancedFeignClient
public interface RemoteRedisPipelinedHashService {

    /**
     * 批量从redis，查询所有hash value
     * @param keyList redis的key集合
     * @param clazz 类型
     * @return 结果，key：redis的key，value：对象
     */
    <T> Map<String, T> multiEntries(List<String> keyList, Class<T> clazz);

    /**
     * 批量设置hash value（hash key 受@JSONField影响）
     * @param map 批量写到redis的map
     * @param timeout 时长
     * @param timeUnit 时间单位
     */
    <T> void multiPutAll(Map<String, T> map, long timeout, TimeUnit timeUnit);

    /**
     * 批量哈希自增
     * @param incrMap key: redis的key，value：需要自增的值
     * @param hashKey 哈希key
     * @param timeout 超时时间
     * @param timeUnit 超时时间单位
     * @return key: redis的key，value：自增后的值
     */
    Map<String, Long> batchHashIncrBy(Map<String, Long> incrMap, String hashKey, long timeout, @NotNull TimeUnit timeUnit);

    /**
     * 批量哈希自增（只有leftLimit<自增前的值<rightLimit时，才会自增）
     * @param keys redis的key集合
     * @param hashKey 哈希key
     * @param delta 需要自增的值
     * @param leftLimit 执行命令之前，若值小于等于该值，则不执行自增
     * @param rightLimit 执行命令之前，若值大于等于该值，则不执行自增
     * @param timeout 超时时间
     * @param timeUnit 超时时间单位
     * @return key: redis的key，value：left:是否自增成功,right:执行操作后的值
     */
    Map<String, Pair<Boolean, Long>> batchHashIncrByIfNonLimit(Set<String> keys, String hashKey, long delta, long leftLimit, long rightLimit, long timeout, @NotNull TimeUnit timeUnit);

    /**
     * 获取翻牌集字-用户记录key
     * @param liveId
     * @param liveUserId
     * @return
     */
    String getUserRecordKey(Long liveId, Long liveUserId);
}
