package cn.com.duiba.live.activity.center.api.remoteservice.marketcoupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.marketcoupon.MarketCouponDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMarketCouponService {

    /**
     * 查询数量
     * @param marketRightsConfId
     * @return
     */
    Long countByParam(Long marketRightsConfId);

    /**
     * 根据creditRightsId查询
     * @param marketRightsConfId
     * @return
     */
    List<MarketCouponDto> getByMarketRightsConfId(Long marketRightsConfId);

    /**
     * 删除
     * @param marketRightsConfId
     * @return
     */
    int deleteByMarketRightsConfId(Long marketRightsConfId);

    /**
     * 保存
     * @param marketCouponDto
     * @return
     */
    long save(MarketCouponDto marketCouponDto);

    /**
     * 保存
     * @param marketCouponDtos
     * @return
     */
    long saveList(List<MarketCouponDto> marketCouponDtos);
}
