package cn.com.duiba.live.activity.center.api.enums.fission;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chenhang
 * @date 2021/11/29 5:13 下午
 */
@Getter
@AllArgsConstructor
public enum BlindBoxDrawTypeEnum {
    BLIND_DRAW_TYPE_TRY(0, "试抽"),
    BLIND_DRAW_TYPE_TRUE(1, "真抽");

    private final Integer status;
    private final String desc;

    private static  final Map<Integer, BlindBoxDrawTypeEnum> ENUM_MAP;

    static {
        ENUM_MAP = Arrays.stream(BlindBoxDrawTypeEnum.values()).collect(Collectors.toMap(BlindBoxDrawTypeEnum::getStatus, Function.identity()));
    }

    public static BlindBoxDrawTypeEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
