package cn.com.duiba.live.activity.center.api.enums.guide;

import cn.com.duiba.live.activity.center.api.util.NumberUtil;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author chengsiyi
 * @date 2020/12/9 10:36
 */
public enum GuideNodeTypeEnum {

    /**
     * 预热轴点类型
     */
    RESOURCE(1, "资料"),
    LOTTERY(2, "抽奖"),
    REDPACKET(3, "红包"),
    WELFARE_RAIN(4, "福利雨"),
    BOOM_APPOINTMENT(5, "爆款预约"),
    ;

    Integer nodeType;

    String desc;

    GuideNodeTypeEnum(Integer nodeType, String desc) {
        this.nodeType = nodeType;
        this.desc = desc;
    }
    private static final Map<Integer, GuideNodeTypeEnum> ENUM_MAP = new HashMap<>();

    public static final Set<Integer> RESOURCE_TYPE = new HashSet<>();

    static{
        for(GuideNodeTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getNodeType(), tmp);
        }
        RESOURCE_TYPE.add(RESOURCE.getNodeType());
        RESOURCE_TYPE.add(BOOM_APPOINTMENT.getNodeType());
    }

    public static GuideNodeTypeEnum getByType(Integer nodeType) {
        return ENUM_MAP.get(nodeType);
    }

    public static boolean isResource(Integer type){
        if(NumberUtil.isNullOrLteZero(type)){
            return false;
        }
        return RESOURCE_TYPE.contains(type);
    }

    public Integer getNodeType() {
        return nodeType;
    }

    public String getDesc() {
        return desc;
    }
}
