package cn.com.duiba.live.activity.center.api.remoteservice.fission.blindbox;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.fission.blindbox.BlindBoxRecordDto;
import cn.com.duiba.live.activity.center.api.param.fission.BlindBoxRecordSearchParam;

import java.util.List;

/***
 * @author chenhang
 * @since 2021-11-25 15:23:17
 */
@AdvancedFeignClient
public interface RemoteBlindBoxRecordService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BlindBoxRecordDto queryById(Long id);
    /**
     * 新增数据
     *
     * @param dto 实例对象
     * @return 实例对象
     */
    Long insert(BlindBoxRecordDto dto);

    /**
     * 修改数据
     *
     * @param dto 实例对象
     * @return 实例对象
     */
    int update(BlindBoxRecordDto dto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    int deleteById(Long id);

    /**
     * 根据条件查询数据
     * @param searchParam
     * @return 记录
     */
    List<BlindBoxRecordDto> selectByParam(BlindBoxRecordSearchParam searchParam);

    /**
     * 批量保存记录
     * @param list
     */
    void batchSave(List<BlindBoxRecordDto> list);

    Long countByRuleId(Long ruleId);


    /**
     * 更新记录状态
     * @param id 主键id
     * @param preStatus 之前状态
     * @param targetStatus  目标状态
     * @return  结果
     */
    int updateStatus(Long id,int preStatus,int targetStatus);

}
