package cn.com.duiba.live.activity.center.api.remoteservice.red.doublered;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.red.doublered.DoubleRedRecordDto;
import cn.com.duiba.live.activity.center.api.param.doublered.DoubleRedRecordPageQueryParam;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/4/10 11:11
 */
@AdvancedFeignClient
public interface RemoteDoubleRedRecordService {

    /**
     * 查询用户领取记录
     * @param confId 配置ID
     * @param liveUserId 用户ID
     * @return
     */
    DoubleRedRecordDto findByConfIdAndUserId(Long confId, Long liveUserId);

    /**
     * 查询用户领取记录
     * @param confId 配置ID
     * @param liveUserIds 用户列表
     * @return
     */
    List<DoubleRedRecordDto> findByConfIdAndUserIds(Long confId, List<Long> liveUserIds);


    Long insert(DoubleRedRecordDto retainedRedRecordDto);

    /**
     * 更新记录
     * @return
     */
    Integer updateById(DoubleRedRecordDto retainedRedRecordDto);

    /**
     * 批量更新记录的完成数量
     * @param ids 记录ID
     * @param completeNum 完成数量
     */
    Integer batchUpdateCompleteNum(List<Long> ids, Integer completeNum);

    /**
     * 调用mq 发红包
     * @param liveId 直播ID
     * @param liveUserId 用户ID
     * @param amount 金额
     */
    Boolean sendRed(Long liveId,Long liveUserId,Integer amount,String ip);

    /**
     * 查询记录
     * @param param
     * @return
     */
    List<DoubleRedRecordDto> findByCondition(DoubleRedRecordPageQueryParam param);
}
