package cn.com.duiba.supplier.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.SupplierDto;
import cn.com.duiba.supplier.center.api.dto.SupplierPageDto;
import cn.com.duiba.supplier.center.api.params.SupplierPageParam;

/**
 * @date:2022/1/7 11:38
 * @author:zhaozhanghai
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteSupplierService {


    SupplierPageDto page(SupplierPageParam supplierPageParam);

    SupplierDto getById(Long supplierId);

    Long save(SupplierDto supplierDto) throws BizException;

    void update(SupplierDto supplierDto) throws BizException;

    /**
     * 根据登陆账号获取供应商信息 登陆账号唯一性
     * @param loginAccount
     * @return
     */
    SupplierDto getByLoginAccount(String loginAccount);




}
