package cn.com.duiba.supplier.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierDto;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierPageDto;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierUpdateDto;
import cn.com.duiba.supplier.center.api.params.SupplierPageParam;

/**
 * @date:2022/1/7 11:38
 * @author:zhaozhanghai
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveSupplierService {


    DuibaLiveSupplierPageDto page(SupplierPageParam supplierPageParam);

    DuibaLiveSupplierDto getById(Long supplierId);

    Long save(DuibaLiveSupplierDto duibaLiveSupplierDto) throws BizException;

    void update(DuibaLiveSupplierUpdateDto duibaLiveSupplierUpdateDto) throws BizException;

    /**
     * 根据登陆账号获取供应商信息 登陆账号唯一性
     * @param loginAccount
     * @return
     */
    DuibaLiveSupplierDto getByLoginAccount(String loginAccount);

    /**
     * 开启停用供应商
     *
     * @param supplierId
     * @param status 0关闭 1开启
     */
    void setSupplierState(Long supplierId,Integer status) throws BizException;





}
